<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::post('login', 'Api\AuthController@login');
Route::post('assis-login', 'Api\AuthController@assislogin');

Route::post('send-otp', 'Api\AuthController@send_otp');
Route::post('assis-send-otp', 'Api\AuthController@assis_send_otp');
Route::post('verify-user', 'Api\AuthController@verify_user');
Route::get('get-assis-doctor', 'Api\Doctor\SlotController@getassistantDoctor');
//User Api
Route::group(['middleware' => ['api', 'multiauth:api'], 'prefix' => 'user'], function () {

    //Routes for Basic Details
    Route::get('user-call', 'Api\User\OpentokController@get_video_user');
    Route::post('call-initiated', 'Api\User\OpentokController@Callinitiated');
    Route::post('call-end', 'Api\User\OpentokController@Callend');
    
    Route::post('firebase', 'Api\User\OpentokController@userfirebaseid');
	Route::get('basic-details', 'Api\User\UserController@get_basic_details');
	Route::post('basic-details', 'Api\User\UserController@basic_details');
    Route::post('profile-upload', 'Api\User\UserController@profile_upload');
    Route::post('profile-update', 'Api\User\UserController@profileupdate');
   
    Route::get('notes', 'Api\Doctor\AppointmentController@Getnotes');
	//Routes for Medical Info
    Route::get('question', 'Api\User\QuestionController@index');
    
	Route::post('medical-info', 'Api\User\UserController@medical_info');
    Route::get('medical-info', 'Api\User\UserController@get_medical_info');
    
	Route::post('upload-prescription', 'Api\User\UserController@upload_prescription');
    Route::post('upload-lab-report', 'Api\User\UserController@upload_lab_report');
    
	Route::post('create-prescription', 'Api\User\UserController@prescription_create');
    Route::post('create-lab-report', 'Api\User\UserController@labreports_create');
    
	Route::get('prescriptions', 'Api\User\UserController@get_prescription_list');
    Route::get('lab-reports', 'Api\User\UserController@get_lab_reports');
    //////check api in postman/////
     Route::get('someone_prescriptions', 'Api\User\UserController@get_someone_prescription_list');
    Route::get('someone_labreports', 'Api\User\UserController@get_someone_lab_reports');
    Route::get('sameone-user-questions', 'Api\User\UserController@get_user_questions');
    ////////postman////////
    Route::get('helthdetails', 'Api\User\UserController@gethelthdetails');
    Route::get('cancel_appointment', 'Api\User\UserController@cancelappointment');
    Route::post('updare_appointment', 'Api\User\UserController@updateappointment');
    Route::get('doctor_info', 'Api\User\UserController@doctorinfo');
    Route::post('online_status', 'Api\User\UserController@doctor_online_status');
    Route::get('doctor_online_status', 'Api\User\UserController@doctoronlinestatus');
    Route::post('someone_appointment/create', 'Api\User\SomeoneController@create');
    Route::get('sameone-appointments', 'Api\User\SomeoneController@sameone_appointments');
    Route::post('payment_data', 'Api\User\UserController@payment_data');
    Route::get('get_transaction', 'Api\User\UserController@get_transaction');
   
    Route::post('email', 'Api\User\AppointmentController@user_update_email');
    Route::get('cancel_appointments', 'Api\User\AppointmentController@Cancelappointments');
   // Route::get('email', 'Api\User\AppointmentController@user_update_email');






	//Routes for slots
	Route::get('slot', 'Api\User\SlotController@index'); // Get To get all slots
	Route::post('appointment/create', 'Api\User\AppointmentController@create');
	Route::post('appointment/create2', 'Api\User\AppointmentController@create2');
    Route::get('appointment', 'Api\User\AppointmentController@index');
    Route::get('appointment_one', 'Api\User\AppointmentController@index_one');
	Route::get('doctor-info', 'Api\User\AppointmentController@get_doctor_info');
	Route::get('myappointments', 'Api\User\AppointmentController@myappointments');
    Route::get('others-appointments', 'Api\User\AppointmentController@others_appointments');

});

//Doctor Api
Route::group(['middleware' => ['api', 'multiauth:doctor'], 'prefix' => 'doctor'], function () {
    Route::get('doctor-call', 'Api\User\OpentokController@get_video');
    Route::post('firebase', 'Api\User\OpentokController@doctorfirebaseid');
    Route::post('assis-firebase', 'Api\User\OpentokController@assistancedoctorfirebaseid');
    Route::get('slot', 'Api\Doctor\SlotController@index');
    Route::get('assis-doctor', 'Api\Doctor\SlotController@assistanceDoctor');
    Route::get('get-assis-doctor', 'Api\Doctor\SlotController@getassistantDoctor');
    Route::post('slot/create', 'Api\Doctor\SlotController@create');
    Route::post('call-end', 'Api\User\OpentokController@Callend');
    Route::get('doctor-info', 'Api\Doctor\SlotController@get_doctor_info');

    Route::post('diagnosis', 'Api\Doctor\SlotController@diagnosis');
  
    Route::get('allappointments', 'Api\Doctor\AppointmentController@index');
    Route::get('get_someone_else', 'Api\Doctor\AppointmentController@get_someone_else');
	Route::get('newappointments', 'Api\Doctor\AppointmentController@newappointments');
	Route::get('upcommingappointments', 'Api\Doctor\AppointmentController@upcomming_appointments');
	Route::get('rescheduled-appointments', 'Api\Doctor\AppointmentController@rescheduled_appointments');
	Route::get('completed-appointments', 'Api\Doctor\AppointmentController@completed_appointments');
	Route::get('cancelled-appointments', 'Api\Doctor\AppointmentController@cancelled_appointments');
    Route::post('update-appointment', 'Api\Doctor\AppointmentController@update_appointment');
    Route::post('user-register', 'Api\Doctor\AppointmentController@UserRegister');
    Route::get('question', 'Api\Doctor\QuestionController@index');
    Route::post('medical-info', 'Api\Doctor\AppointmentController@medical_info');
    Route::get('medical-info', 'Api\Doctor\AppointmentController@get_medical_info');
    Route::post('create-prescription', 'Api\Doctor\AppointmentController@prescription_create');
    Route::post('create-lab-report', 'Api\User\UserController@labreports_create');
    Route::post('prescription-update', 'Api\Doctor\AppointmentController@prescriptionupdate');
    Route::post('lab-report-update', 'Api\Doctor\AppointmentController@labreportsupdate');
   // Route::post('update-appointment', 'Api\Doctor\AppointmentController@update_appointment');
   
    Route::post('notes', 'Api\Doctor\AppointmentController@ClinicalNote');
    Route::get('notes', 'Api\Doctor\AppointmentController@Getnotes');
	Route::get('view-ledger', 'Api\Doctor\SlotController@view_ledger');
	Route::post('doctor_profile-upload', 'Api\Doctor\SlotController@profile_upload');
    Route::post('update_rescheduled_appointments', 'Api\Doctor\AppointmentController@update_rescheduled_appointment');
    ///////////patient data////////////
    Route::get('all_appointments', 'Api\Doctor\AppointmentController@get_all_appointment');
	Route::get('patient_prescriptions', 'Api\Doctor\AppointmentController@getprescriptions');
	Route::get('patient_labreports', 'Api\Doctor\AppointmentController@getlabreports');
    Route::get('patient_helthdetails', 'Api\Doctor\AppointmentController@gethelthdetails');
    Route::get('patient_info', 'Api\Doctor\AppointmentController@patient_info');
    Route::post('online_status', 'Api\Doctor\AppointmentController@doctor_online_status');
    Route::post('doctor-basic-details', 'Api\Doctor\SlotController@basic_details');
	Route::post('doctor-upload-prescription', 'Api\Doctor\SlotController@upload_prescription');
    Route::post('doctor-upload-lab-report', 'Api\Doctor\SlotController@upload_lab_report');
    Route::get('all_patients', 'Api\Doctor\AppointmentController@all_patient');
    Route::get('doctor_question', 'Api\User\QuestionController@index');
    Route::post('doctor_qut_ans', 'Api\Doctor\SlotController@doctor_medical_info');
    Route::get('doctor_qut_ans', 'Api\Doctor\SlotController@get_medical_info');
    
    /***               
     *  ###############################Assistant Doctor API####################
     */
    Route::get('assis-allappointments', 'Api\Assistantdoctor\AppointmentController@index');
    Route::get('assis-doctor-call', 'Api\User\OpentokController@assisget_video');
    Route::post('assis-firebase', 'Api\User\OpentokController@doctorfirebaseid');
    //Route::post('assis-firebase', 'Api\User\OpentokController@assistancedoctorfirebaseid');

    Route::get('assis-slot', 'Api\Assistantdoctor\SlotController@index');
    Route::get('assis-doctor', 'Api\Assistantdoctor\SlotController@assistanceDoctor');
    Route::post('assis-slot/create', 'Api\Assistantdoctor\SlotController@create');
    Route::post('assis-call-end', 'Api\User\OpentokController@Callend');
    Route::get('assis-doctor-info', 'Api\Assistantdoctor\SlotController@get_doctor_info');
    Route::post('assis-diagnosis', 'Api\Assistantdoctor\SlotController@diagnosis');
    Route::get('assis-allappointments', 'Api\Assistantdoctor\AppointmentController@index');
    Route::get('assis-get_someone_else', 'Api\Assistantdoctor\AppointmentController@get_someone_else');
	Route::get('assis-newappointments', 'Api\Assistantdoctor\AppointmentController@newappointments');
	Route::get('assis-upcommingappointments', 'Api\Assistantdoctor\AppointmentController@upcomming_appointments');
	Route::get('assis-rescheduled-appointments', 'Api\Assistantdoctor\AppointmentController@rescheduled_appointments');
	Route::get('assis-completed-appointments', 'Api\Assistantdoctor\AppointmentController@completed_appointments');
	Route::get('assis-cancelled-appointments', 'Api\Assistantdoctor\AppointmentController@cancelled_appointments');
    Route::post('assis-update-appointment', 'Api\Assistantdoctor\AppointmentController@update_appointment');
    Route::post('assis-user-register', 'Api\Assistantdoctor\AppointmentController@UserRegister');
    Route::get('assis-question', 'Api\Assistantdoctor\QuestionController@index');
    Route::post('assis-medical-info', 'Api\Assistantdoctor\AppointmentController@medical_info');
    Route::get('assis-medical-info', 'Api\Assistantdoctor\AppointmentController@get_medical_info');
    Route::post('assis-create-prescription', 'Api\Assistantdoctor\AppointmentController@prescription_create');
    Route::post('assis-create-lab-report', 'Api\User\UserController@labreports_create');
    Route::post('assis-prescription-update', 'Api\Assistantdoctor\AppointmentController@prescriptionupdate');
    Route::post('assis-lab-report-update', 'Api\Assistantdoctor\AppointmentController@labreportsupdate');
   // Route::post('update-appointment', 'Api\Doctor\AppointmentController@update_appointment');
   
    Route::post('assis-notes', 'Api\Assistantdoctor\AppointmentController@ClinicalNote');
    Route::get('assis-notes', 'Api\Assistantdoctor\AppointmentController@Getnotes');
	Route::get('assis-view-ledger', 'Api\Assistantdoctor\SlotController@view_ledger');
	Route::post('assis-doctor_profile-upload', 'Api\Assistantdoctor\SlotController@profile_upload');
    Route::post('assis-update_rescheduled_appointments', 'Api\Assistantdoctor\AppointmentController@update_rescheduled_appointment');
    ///////////patient data////////////
    Route::get('assis-all_appointments', 'Api\Assistantdoctor\AppointmentController@get_all_appointment');
	Route::get('assis-patient_prescriptions', 'Api\Assistantdoctor\AppointmentController@getprescriptions');
	Route::get('assis-patient_labreports', 'Api\Assistantdoctor\AppointmentController@getlabreports');
    Route::get('assis-patient_helthdetails', 'Api\Assistantdoctor\AppointmentController@gethelthdetails');
    Route::get('assis-patient_info', 'Api\Assistantdoctor\AppointmentController@patient_info');
    Route::post('assis-online_status', 'Api\Assistantdoctor\AppointmentController@doctor_online_status');
    Route::post('assis-doctor-basic-details', 'Api\Assistantdoctor\SlotController@basic_details');
	Route::post('assis-doctor-upload-prescription', 'Api\Assistantdoctor\SlotController@upload_prescription');
    Route::post('assis-doctor-upload-lab-report', 'Api\Assistantdoctor\SlotController@upload_lab_report');
    Route::get('assis-all_patients', 'Api\Assistantdoctor\AppointmentController@all_patient');
    Route::get('assis-doctor_question', 'Api\User\QuestionController@index');
    Route::post('assis-doctor_qut_ans', 'Api\Assistantdoctor\SlotController@doctor_medical_info');
    Route::get('assis-doctor_qut_ans', 'Api\Assistantdoctor\SlotController@get_medical_info');
    
});
