@extends('layouts.masterlayout')
@section('content')
 
 <div class="clearfix"></div>
<!--Main Slide start-->
<section class="cat_section">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-xl-12 col-lg-12 col-sm-12 col-12">
                <div class="category_block">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb"> 
                          <li class="breadcrumb-item"><a href="{{url('/')}}">Home</a></li>
                          <li class="breadcrumb-item"><a href='{{url("college/$Category->slugs")}}'>{{$Category->category_name or ''}}</a></li>
                          
                        </ol> 
                      </nav>
                      <input type="hidden" name="category_id" value="{{$Category->id}}" id="category_id">
                    <h1><span>{{$Category->category_name or ''}} Colleges in India</span></h1>
                    <p><span>{{collegecount($Category->id)}}</span> Colleges in India offering {{ strtolower($Category->category_name)}} courses</p>
                </div
            </div>
        </div>
    </div>
</section>
<!--Main Slide end-->
<!--Category page Start-->
<section class="category_section">
    <div class="container">
        <div class="row">
            <div class="col-md-3 col-lg-3 col-sm-3 col-xl-3 col-12">
              <form name="filter" id="filter">
                <div class="filter_block">
                    <div class="filter_label">
                            <h2>Filter <span class="float-right"><a style="color:#f8f9fa;" href='{{url("college/$Category->slugs")}}'>Reset</a></span></h2>
                    </div>
                    <div class="filter_list">
                      <p>Top/Trending College</p>
                      <div class="search_block">
                         
                        <div class="label"><input type="checkbox" name="top" value="1"> Top </div>
                        <div class="label"><input type="checkbox" name="trending" value="1"> Trending</div>
                         
                         
                        </div>
                    </div>
                    <div class="filter_list">
                      <p>Degree</p>
                      <div class="search_block">
                        <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                         
                        @if(!empty($degreelist))
                        @foreach($degreelist as $key=>$value)
                        <div class="label"><input type="checkbox" name="degree" value="{{$value->degree or ''}}">{{$value->degree or ''}} <span>({{$value->count or ''}})</span></div>
                        @endforeach
                        @endif
                         
                        </div>
                    </div>
                    <div class="filter_list">
                            <p>State</p>
                        <div class="search_block">
                          <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                        @if(!empty($statelist))
                        @foreach($statelist as $key=>$value)
                        <div class="label"><input type="checkbox" name="state_name" value="{{$value->state_name or ''}}">{{$value->state_name or ''}} <span>({{$value->count or ''}})</span></div>
                        @endforeach
                        @endif
                        </div>
                      </div>
                      <div class="filter_list">
                            <p>City</p>
                        <div class="search_block">
                          <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                        @if(!empty($citylist))
                        @foreach($citylist as $key=>$value)
                        <div class="label"><input type="checkbox" name="city_name" value="{{$value->city_name or ''}}">{{$value->city_name or ''}} <span>({{$value->count or ''}})</span></div>
                        @endforeach
                        @endif
                        </div>
                        </div>
                      <div class="filter_list">
                            <p>Study Mode</p>
                        <div class="search_block">
                          <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                             @if(!empty($degreetype))
                        @foreach($degreetype as $key=>$value)
                        <div class="label"><input type="checkbox" name="degree_type" value="{{$value->degree_type or ''}}">{{$value->degree_type or ''}} <span>({{$value->count or ''}})</span></div>
                        @endforeach
                        @endif
                        </div>
                      </div>
                    <div class="filter_list">
                            <p>Approvals / Recognition</p>
                        <div class="search_block">
                           
                          <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                             @if(!empty($affilitiontype))
                          
                        @foreach($affilitiontype as $key=>$value)
                        <div class="label"><input type="checkbox" name="Affilitation_id" value="{{$key or ''}}">{{$value or ''}}</div>
                        @endforeach
                        @endif
                        </div>
                      </div>
                  <div class="filter_list">
                            <p>Ownership</p>
                        <div class="search_block">
                           
                          <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                             @if(!empty($collagesector))
                          
                        @foreach($collagesector as $key=>$value)
                        <div class="label"><input type="checkbox" name="college_type" value="{{$key or ''}}">{{$value or ''}}</div>
                        @endforeach
                        @endif
                        </div>
                 </div>
                 <div class="filter_list">
                            <p>Facilities</p>
                        <div class="search_block">
                           
                          <input type="text" class="search_text" placeholder="Search" name="searchColumn" id="searchColumn"/>
                             @if(!empty($facility))
                          
                        @foreach($facility as $key=>$value)
                        <div class="label"><input type="checkbox" name="facility" value="{{$key or ''}}">{{$value or ''}}</div>
                        @endforeach
                        @endif
                        </div>
                 </div>
                

                </div>
              </form>
            </div>
             <div class="col-12 col-lg-9 col-sm-9 col-xl-9 col-md-9" >
                <div class="row" id="post-data">
              @include('frontend.pages.ajaxloadcollege')
              </div>
                
                <?php  //echo $colleges->links(); ?>
            </div>

        </div>
    </div>

</section>
<script type="text/javascript">
  function GetFilters() {
      $('input[type="checkbox"]').on('change', function (e) {
          var data = {},
              fdata = [],
              loc = $('<a>', { href: window.location })[0];
          $('input[type="checkbox"]').each(function (i) {
              if (this.checked) {
                  if (!data.hasOwnProperty(this.name)) {
                      data[this.name] = [];
                  }
                  data[this.name].push(this.value);
              }
          });
          // get all keys.
          var keys = Object.keys(data);
          var fdata = "";
          // iterate over them and create the fdata
          keys.forEach(function(key,i){
              if (i>0) fdata += '&'; // if its not the first key add &
              fdata += key+"="+data[key].join(',');
          });
           var category_id=$('#category_id').val();
            
          $.ajax({
            type: "get",
            url: '/filter-college/?category_id='+category_id,
            data:   fdata,
            success: function (data) {
              $('#post-data').html('');
              $("#post-data").append(data.html);
            }
          });
          if (history.pushState) {
              history.pushState(null, null, loc.pathname + '?' + fdata);
          }
      });
  }
  window.onload = GetFilters;
  </script>

  <script type="text/javascript">
  var page = 1;
  var lastpage=<?php echo $lastPage ?>;
  $(window).scroll(function() {
      if($(window).scrollTop() + $(window).height() >= $(document).height()) {
          page++;
         if(page<=lastpage)
         {
          loadMoreData(page);
         }
          
      }
  });

  function loadMoreData(page){

    var data = {},
              fdata = [],
              loc = $('<a>', { href: window.location })[0];
          $('input[type="checkbox"]').each(function (i) {
              if (this.checked) {
                  if (!data.hasOwnProperty(this.name)) {
                      data[this.name] = [];
                  }
                  data[this.name].push(this.value);
              }
          });
          // get all keys.
          var keys = Object.keys(data);
          var fdata = "";
          // iterate over them and create the fdata
          keys.forEach(function(key,i){
              if (i>0) fdata += '&'; // if its not the first key add &
              fdata += key+"="+data[key].join(',');
          });
    $.ajax(
          {
              url: '?page=' + page,
              type: "get",
              data: fdata, 
              beforeSend: function()
              {
                  $('.ajax-load').show();
              }
          })
          .done(function(data)
          {
              if(data.html == " "){
                  $('.ajax-load').html("No more records found");
                  return;
              }
              $('.ajax-load').hide();
              $("#post-data").append(data.html);
          })
          .fail(function(jqXHR, ajaxOptions, thrownError)
          {
                alert('server not responding...');
          });
  }
</script>
<script type="text/javascript">
  
  function ApplyNOW(clogid)
      {
         if(clogid)
          {
           $.ajax({
                    type: "POST",
                    dataType: "json",
                    url:"/college-Apply",
                    data: {
                    "_token": "{{ csrf_token() }}",
                    "clogid": clogid
                    },
                    statusCode: {
                          200: function (res) {
                                
                          },
                          422: function(res) {
                               
                          },
         
                    },
                });
         }
      }

</script>
 
<!--Category page end-->
@endsection
