<?php

namespace App\Model;

use App\Model\Someone_AppointmentDetail;
use App\Model\AppointmentReport;
use App\Model\Slot;
use App\User;
use Illuminate\Database\Eloquent\Model;

class Someone_Appointment extends Model
{
    protected $fillable = [
    	'appointment_no', 'user_id', 'slot_id', 'status','doctor_id','date','transaction_id','total_amount','reason','transaction_type'
    ];

    public function slot(){
    	return $this->belongsTo(Slot::class);
    }

    public function user(){
    	return $this->belongsTo(User::class);
    }

    public function appointment_details(){
    	return $this->hasOne(Someone_AppointmentDetail::class);
    }

    public function appointment_reports(){
    	return $this->hasMany(AppointmentReport::class);
    }
}
