<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Appointment extends Model
{
    protected $table="appointments";
    
    protected $fillable = [
    	'appointment_no', 'user_id', 'slot_id', 'status','doctor_id','date','transaction_id','total_amount','reason','transaction_type'
    ];

    public function Appointmentdetail()
    {
        return $this->hasOne('App\Model\AppointmentDetail');
    }

    public function appointmentreports()
    {
        return $this->hasMany('App\Model\AppointmentReport');
    }
    public function appointmentlog()
    {
        return $this->hasMany('App\Model\AppointmentLog');
    }

    public function doctor()
    {
        return $this->belongsTo('App\Model\Doctor');
         
    }

    public function slot(){
    	return $this->belongsTo(Slot::class);
    }
     
    public function currentslot(){
    	return $this->belongsTo(Slot::class)->whereDate('date', '>=',Carbon::today()->toDateString());
    }
    public function user(){
    	return $this->belongsTo(User::class);
    }

    public function appointment_details(){
    	return $this->hasOne(AppointmentDetail::class);
    }

    public function appointment_reports(){
    	return $this->hasMany(AppointmentReport::class);
    }

     
}
