<?php

namespace App\Http\Resources\Doctor;

use App\Doctor;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\SlotResource;
use App\Model\Slot;
use App\Model\DoctorDetails;
use App\Model\AppointmentDetail;
use App\Model\UserDetails;
use App\User;


use Illuminate\Http\Resources\Json\JsonResource;

class AppointmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
          
            return [
                'id' => $this->id,
                'appointment_no' => $this->appointment_no,
                'patient_id' => $this->user_id,
                'status' => $this->status,
                'slot' => new SlotResource(Slot::find($this->slot_id)),
                'appointment_info' => AppointmentDetail::whereAppointmentId($this->id)->first(),
                'patient_info' => UserDetails::whereUserId($this->user_id)->first(),
                'patient_profile_info' => User::whereId($this->user_id)->first(),

            ];


    }
}
