<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserQuestionResource;
use App\Http\Resources\User\UserResource;
use App\Model\Question;
use App\Model\UserAdditionalQuestion;
use App\Model\UserDetails;
use App\Model\UserQuestion;
use App\Model\UserPrescriptions;
use App\Model\UserLabReports;
use App\Model\Someone_AppointmentDetail;
use App\Model\UserAmount;
use App\Model\UserWalletBalance;
use App\Model\DoctorRates;
use App\User;
use Auth;
use DB;
use Illuminate\Http\Request;
use Storage;
use App\Model\Appointment;
use Toastr;
use Validator;
use App\Model\Slot;
use Mailgun;
use App\Helpers\Helper;

class UserController extends Controller
{
    public function basic_details(Request $request){
    	$validator = Validator::make($request->all(),[
    		'name' => 'required|max:191',
    		'email' => 'required|email|max:191|unique:users,email,'.Auth::id(),
    		'dob' => 'required|date|before_or_equal:today',
    		'gender' => 'required|numeric|min:1|max:3',
    	]);

    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'Error' => $errors]);
    	}

    	// Database Operation
    	try {
    		DB::beginTransaction();

    		$user = Auth::user();
    		$user->name = $request->name;
    		$user->email = $request->email;
    		$user->save();

    		UserDetails::updateOrCreate([
    			'user_id' => Auth::id()
    		],[
    			'dob' => date('Y-m-d', strtotime($request->dob)),
    			'gender' => $request->gender,
    		]);

    		DB::commit();
    	}
    	catch (Exception $e) {
    		DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
    	}

    	// User Resouce collection Instance.
    	$user = new UserResource($user);
    	return response()->json(['status' => true, 'message' => 'User basic details updated', 'data' => $user]);
    }

    public function profile_upload(Request $request){
    	$validator = Validator::make($request->all(),[
    		'profile' => 'required|image',
    	]);
        
    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    	}

    	try {
            $file = $request->file('profile');
            $path = Storage::put('uploads/profile', $file);
            //dd($path);
            UserDetails::updateOrCreate([
    			'user_id' => Auth::id()
    		],[
    			'profile' => $path
    		]);

    	}
    	catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
    	}

    	// User Resouce collection Instance.
    	$user = new UserResource(Auth::user());
    	return response()->json(['status' => true, 'message' => 'User Created', 'data' => $user]);
    }

    public function profileupdate(Request $request)
    {
         $userid=Auth::id();
         if($userid)
         {
            try{
                $obj= User::findOrFail($userid);
                $obj->name=($request->name)?$request->name:$obj->name;
                $obj->mobile=($request->mobile)?$request->mobile :$obj->mobile;
                $obj->email=($request->email)?$request->email:$obj->email;
                $obj->online_status=($request->online_status)?$request->online_status:$obj->online_status;
                $obj->save();
                 
                    
                $rs=UserDetails::where('user_id',$userid)->first();
        
                if($rs)
                {
                     $obj2= UserDetails::findOrFail($rs->id);
                     $obj2->user_id=$userid;
                    }else{
                      $obj2= new  UserDetails;
                }
               
                $obj2->dob=($request->dob)?$request->dob:$obj2->dob;
                $obj2->gender=($request->gender)?$request->gender:$obj2->gender ;
                $obj2->save();
                return response()->json(['status' => true, 'message' => 'User Updated', 'user' => $obj,'userdetail'=>$obj2]);
            }catch (Exception $e) {
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
            
         }else{
            return response()->json(['status' => false, 'message' => 'user Not exist']);
         }
    }

    public function get_basic_details(){

        $data = new UserResource(Auth::user());
        $user_question = UserQuestion::whereUserId(Auth::id())->get();
        $data_question='';
        if($user_question->isNotEmpty()){
            $data_question = UserQuestionResource::collection($user_question);
        }
        $user_additional_question = UserAdditionalQuestion::whereUserId(Auth::id())->get();
        $user_additional_questions='';
        if($user_additional_question->isNotEmpty()){
           $user_additional_questions=$user_additional_question;
        }
        $patient_prescriptions = UserPrescriptions::whereUserId(Auth::id())->get();
        $patient_lab_reports = UserLabReports::whereUserId(Auth::id())->get();
        $data = array("profile_info"=>$data,"health_details"=>$data_question,"additional_question"=>$user_additional_questions,"patient_prescriptions"=>$patient_prescriptions,"patient_lab_reports"=>$patient_lab_reports);
        return response()->json(['status' => true, 'message' => 'User details', 'data' => $data]);
    }

    public function medical_info(Request $request){
        $validator = Validator::make($request->all(),[
            'questions' => 'required', 'json',
            'allergies' => 'nullable',
            'ailments' => 'nullable',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            DB::beginTransaction();
            $questions = json_decode($request->questions, true);
            $appoinment_type = $request->appoinment_type;
            UserQuestion::where('user_id',Auth::id())->delete();
            foreach ($questions as $key => $value) {

                if(!Question::find($key)){
                    return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => 'Invalid Question id '. $key]);
                }

                UserQuestion::updateOrCreate([
                    'user_id' => Auth::id(),
                    'question_id' => $key,
                    'appoinment_type'=>$appoinment_type
                ],[
                    'answer' => $value
                ]);
            }

            UserAdditionalQuestion::updateOrCreate([
                'user_id' => Auth::id(),
            ],[
                'allergies' => $request->allergies,
                'ailments' => $request->ailments
            ]);
            DB::commit();
        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'User Question Updated']);
    }

    public function get_medical_info(){

        $user_question = UserQuestion::whereUserId(Auth::id())->get();

        if($user_question->isNotEmpty()){
            $data = UserQuestionResource::collection($user_question);
            return response()->json(['status' => true, 'message' => 'User Question', 'data' => $data]);
        }

        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }

    public function upload_prescription(Request $request){

        $validator = Validator::make($request->all(),[
            'prescription' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('prescription');
            $path = Storage::put('uploads/prescriptions', $file);

            UserAdditionalQuestion::updateOrCreate([
                'user_id' => Auth::id(),
            ],[
                'prescription' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'Presciption Uploaded']);
    }

    public function upload_lab_report(Request $request){
        $validator = Validator::make($request->all(),[
            'report' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('report');
            $path = Storage::put('uploads/lab-reports', $file);

            UserAdditionalQuestion::updateOrCreate([
                'user_id' => Auth::id(),
            ],[
                'lab_reports' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'Lab Report Uploaded']);
    }


    public function prescription_create(Request $request){
        $validator = Validator::make($request->all(),[
            'prescription' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        // Database Operation
        try {

            $file = $request->file('prescription');
            $appoinment_type = $request->appoinment_type;
            $date = $request->date;
            $path = Storage::put('uploads/prescriptions', $file);
            DB::beginTransaction();

            UserPrescriptions::Create([
                'user_id' => Auth::id(),
                'prescription' => $path,
                'appoinment_type'=> $appoinment_type,
                'date'=> $date,
            ]);

            DB::commit();
        }
        catch (Exception $e) {
            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
        return response()->json(['status' => true, 'message' => 'Presciption Uploaded']);
    }


    public function labreports_create(Request $request){
        $validator = Validator::make($request->all(),[
            'lab_reports' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        // Database Operation
        try {

            $file = $request->file('lab_reports');
            $appoinment_type = $request->appoinment_type;
            $date = $request->date;
            $path = Storage::put('uploads/lab-reports', $file);
            DB::beginTransaction();

            UserLabReports::Create([
                'user_id' => Auth::id(),
                'lab_reports' => $path,
                'appoinment_type'=>$appoinment_type,
                'date'=>$date
            ]);

            DB::commit();
        }
        catch (Exception $e) {
            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
        return response()->json(['status' => true, 'message' => 'Lab Reports Uploaded']);
    }


    public function get_prescription_list(){

        $patient_prescription = UserPrescriptions::whereUserId(Auth::id())->get();
        if($patient_prescription->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Prescriptions', 'data' => $patient_prescription]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function get_lab_reports(){

        $patient_lab_reports = UserLabReports::whereUserId(Auth::id())->get();
        if($patient_lab_reports->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Lab Reports', 'data' => $patient_lab_reports]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    // public function getprescriptions(){

    //     $patient_prescriptions = UserPrescriptions::whereUserId(Auth::id())
    //     ->orderBy('created_at','DESC')
    //     ->get();


    //     if($patient_prescriptions->isNotEmpty()){
    //         return response()->json(['status' => true, 'message' => 'User Prescriptions', 'data' => $patient_prescriptions]);
    //     }
    //     return response()->json(['status' => false, 'message' => 'No Containt Found']);
    // }
    // public function getlabreports(){
    //     $patient_labreports = UserLabReports::whereUserId(Auth::id())
    //     ->orderBy('created_at','DESC')
    //     ->get();
    //     //dd(Auth::id());
    //     if($patient_labreports->isNotEmpty()){
    //         return response()->json(['status' => true, 'message' => 'User Lab Reports', 'data' => $patient_labreports]);
    //     }
    //     return response()->json(['status' => false, 'message' => 'No Containt Found']);
    // }
    public function gethelthdetails(){
      //  DB::enableQueryLog();
       $notid=array(2);
        $helthdetails = DB::table('questions')
        ->join('user_questions', 'user_questions.question_id', '=', 'questions.id')
        ->select('questions.question','user_questions.answer','questions.id','user_questions.user_id')
        ->where('user_questions.user_id',Auth::id())
      //  ->where('user_questions.appoinment_type',1)
        ->orderby('user_questions.id')
        ->distinct('user_questions.id')
        
         ->get();
         
        $user_additional_question = UserAdditionalQuestion::whereUserId(Auth::id())->get();
        $message=array('additionalquestion'=>array('message'=>'question unavailable'));

        $additional=empty($user_additional_question)? $message:$user_additional_question;
        //dd(DB::getQueryLog());

        if($helthdetails->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Helth Details', 'data' => $helthdetails,'additional'=>$additional]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function cancelappointment(Request $request)
    {

        $appointment_no=$request->appointment_no;
        $status=array('status'=>'4');
        $data= DB::table('appointments')
        ->where('appointment_no',$appointment_no)
        ->update($status);
        
         $data=Appointment::where('appointment_no',$appointment_no)->first();
         ///update slot after cancel
         $slotid=$data->slot_id;
         if($slotid)
         {
            $slot=Slot::find($slotid);
            $slot->status=0;
            $slot->save();
         }
         
         Helper::Firebasedata('Cancelappointment',$data);
        if($data)
        {
            $rs= DB::table('appointments')
           ->where('appointment_no',$appointment_no)->first(); 
           $wallet=new UserWalletBalance;
           $wallet->user_id=$rs->user_id;
           $wallet->doctor_id=$rs->doctor_id;
           $wallet->transaction_id=$rs->transaction_id;
           $wallet->payment_type='credit';
           $wallet->appointment_type='Accept';
           $wallet->amount=$rs->total_amount;
           $wallet->save();
           
           
           // $useramount=new UserAmount;
           // $useramount->user_id=$rs->user_id;
           // $useramount->doctor_id=$rs->doctor_id;
           // $useramount->transaction_id=$rs->transaction_id;
           // $useramount->total_amount=$rs->total_amount;
           // $useramount->save();
           $rsdata =Appointment::with('Appointmentdetail','doctor','slot')->where('id',$data->id)->first();
           $this->send_user_appointment_sms($rsdata);
        }
        
        

       /*  $total_amount=DB::table('appointments')
        ->select('total_amount')
        ->where('appointment_no',$appointment_no)
        ->get(); */
       return response()->json(['status' => true, 'message' => 'Cancel Appointments', 'data' => $data]);
    }
    public function updateappointment(Request $request)
    {
         try {

              $appointment_no=$request->appointment_no;

              $consultation_type=$request->consultation_type;

              $slot=$request->slot;

              /// if user change consultation_type 2 to 1
              $consultation=DB::table('appointments')
                            ->join('appointment_details','appointment_details.appointment_id','appointments.id')
                            ->select('appointment_details.*','appointments.total_amount','appointments.user_id','appointments.doctor_id','appointments.slot_id')
                            ->where('appointment_no',$appointment_no)->first();
              $previousslotid=$consultation->slot_id;
              //dd($consultation);
              if($previousslotid)
               {
                $ss=Slot::find($previousslotid);
                $ss->status=0;
                $ss->save();
               }
                $next=Slot::find($request->slot);
                $next->status=1;
                $next->save();
               $consultation_total_amount=$consultation->total_amount;
              if($consultation->consultation_type==2 && $request->consultation_type==1)
              {
                $consultation_total_amount=$consultation->total_amount;
                //dd($consultation_total_amount,$request->total_amount);
                //$DoctorRates=DoctorRates::where('doctor_id',$consultation->doctor_id)->first
                $getID=$consultation->appointment_id;
                $consultation_data=array('consultation_type' =>$consultation_type);
                 
               
                // $UserAmount=new UserAmount;
                // $UserAmount->user_id=$consultation->user_id;
                // $UserAmount->doctor_id=$consultation->doctor_id;
                // $UserAmount->transaction_id=time();
                // $UserAmount->total_amount=$consultation_total_amount-$request->total_amount;
                // $UserAmount->save();

                $UserWalletBalance= new UserWalletBalance;
                $UserWalletBalance->user_id=$consultation->user_id;
                $UserWalletBalance->doctor_id=$consultation->doctor_id;
                $UserWalletBalance->transaction_id=time();
                $UserWalletBalance->payment_type='credit';
                $UserWalletBalance->appointment_type='Accept';
                $UserWalletBalance->amount=$consultation_total_amount-$request->total_amount;
                $UserWalletBalance->save();
                

                DB::table('appointment_details')
                ->where('appointment_id',$getID)
                ->update($consultation_data);
                $slot_data=array('slot_id' =>$slot,'total_amount'=>$request->total_amount);

                $data_update= DB::table('appointments')
                ->where('appointment_no',$appointment_no)
                ->update($slot_data);

               
              
            }else{
                $consultation->total_amount;
                $request->total_amount;
              $slot_data=array('slot_id' =>$slot,'total_amount'=>$request->total_amount);
              $get_appointment_no=DB::table('appointments')->select('id')->where('appointment_no',$appointment_no)->get();
              $getID=$get_appointment_no[0]->id;
              $consultation_data=array('consultation_type' =>$consultation_type);
              DB::table('appointment_details')
              ->where('appointment_id',$getID)
              ->update($consultation_data);

              $data_update= DB::table('appointments')
               ->where('appointment_no',$appointment_no)
               ->update($slot_data);

               $UserWalletBalance= new UserWalletBalance;
                $UserWalletBalance->user_id=$consultation->user_id;
                $UserWalletBalance->doctor_id=$consultation->doctor_id;
                $UserWalletBalance->transaction_id=time();
                if($consultation->total_amount<$request->total_amount)
                {
                    $UserWalletBalance->payment_type='debit';
                    $UserWalletBalance->amount=$request->total_amount-$consultation_total_amount;
                    
                }else{
                    $UserWalletBalance->payment_type='credit';
                    $UserWalletBalance->amount=$consultation_total_amount-$request->total_amount;
                }

                $UserWalletBalance->appointment_type='Accept';
                
                $UserWalletBalance->save();

                
              }
               

              $rsdata =Appointment::with('Appointmentdetail','doctor','slot')->where('id',$getID)->first();
              $this->send_user_appointmentupdate_sms($rsdata);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
       $data= Appointment::where('appointment_no',$request->appointment_no)->first(); 
       Helper::Firebasedata('RescheduleAppointment',$data);
    return response()->json(['status' => true, 'message' => 'Update Appointments']);
    }
    public function doctorinfo(Request $request)
    {
        $doctor_id=$request->doctor;
        $doctordetails = DB::table('doctors')
        ->join('doctor_details', 'doctor_details.doctor_id', '=', 'doctors.id')
        ->where('doctor_details.doctor_id',$doctor_id)
        ->get();
        if($doctordetails->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'Doctor Details', 'data' => $doctordetails]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function doctoronlinestatus(Request $request)
    {

       $doctor_id=$request->doctor_id;
        //dd();
        $helthdetails = DB::table('doctors')
        ->select('online_status')
        ->where('id',$doctor_id)
        ->get();

        if($helthdetails->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'Doctor Online Status', 'data' => $helthdetails]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function get_someone_prescription_list(){

       // $patient_prescription = Someone_AppointmentDetail::whereUserId(Auth::id())->select('prescription','created_at')->get();
       $patient_prescription=DB::table('someone__appointments')
       ->leftjoin('someone__appointment_details','someone__appointment_details.appointment_id','=','someone__appointments.id')
       ->where('someone__appointments.user_id',Auth::id())
       ->select('someone__appointment_details.prescription','someone__appointments.created_at')
       ->get();
        if($patient_prescription->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Prescriptions', 'data' => $patient_prescription]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function get_someone_lab_reports(){

       // $patient_lab_reports = Someone_AppointmentDetail::whereUserId(Auth::id())->select('lab_reports','created_at')->get();
       $patient_lab_reports=DB::table('someone__appointments')
       ->leftjoin('someone__appointment_details','someone__appointment_details.appointment_id','=','someone__appointments.id')
       ->where('someone__appointments.user_id',Auth::id())
       ->select('someone__appointment_details.lab_reports','someone__appointments.created_at')
       ->get();
        if($patient_lab_reports->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Lab Reports', 'data' => $patient_lab_reports]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function get_user_questions(){

        $user_question = UserQuestion::whereUserId(Auth::id())->where('appoinment_type',2)->get();

        if($user_question->isNotEmpty()){
            $data = UserQuestionResource::collection($user_question);
            return response()->json(['status' => true, 'message' => 'User Question', 'data' => $data]);
        }

        return response()->json(['status' => false, 'message' => 'No Containt Found']);



    }
    public function payment_data(Request $request)
    {
        $data=array(
                        'user_id'=>Auth::id(),
                        'doctor_id'=>$request->doctor_id,
                        'transaction_id'=>$request->transaction_id,
                        'total_amount'=>$request->total_amount
                    );
          $inserted=  DB::table('user_amount')->insert($data);

          return response()->json(['status' => true, 'message' => 'Data save ']);
    }

    public function get_transaction()
    {
        $patient_transaction = DB::table('user_amount')->where('user_id',Auth::id())->get();
        $appointment_transaction = DB::table('appointments')->select('transaction_id','total_amount','reason')->where('user_id',Auth::id())->where('transaction_type',1)->get();
        $someone_transaction = DB::table('someone__appointments')->select('transaction_id','total_amount','reason')->where('user_id',Auth::id())->where('transaction_type',1)->get();
        $data=array('patient_transaction'=>$patient_transaction,'appointment_transaction'=>$appointment_transaction,'someone_transaction'=>$someone_transaction);
       // if($data->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Transaction Reports', 'data' => $data]);
       // }
       // return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }

    public function user_email()
    {
        \Mail::send([], [], function ($message) {
            $message->to('developer44@indglobal-consulting.com', 'John Doe')
                ->subject('Welcome!')
                ->setBody('<h1>Hi, welcome user!</h1>', 'text/html');
        });
       //https://github.com/Bogardo/Mailgun
       //https://medium.com/@OlabodeAbesin/how-to-send-emails-with-mailgun-in-laravel-easy-in-4-steps-451ebc1c5574
    }

   /*  public function doctorinfo(Request $request)
    {
        $doctor_id=$request->doctor;
        $doctordetails = DB::table('doctors')
        ->join('doctor_details', 'doctor_details.doctor_id', '=', 'doctors.id')
        ->where('doctor_details.doctor_id',$doctor_id)
        ->get();
        if($doctordetails->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'Doctor Details', 'data' => $doctordetails]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    } */

    public function send_user_appointment_sms($appointment){
        
        ///user sms
       $data['mobile'] = $appointment->Appointmentdetail->mobile;
       $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an appointment cancelled with ". $appointment->doctor->name." on " .$appointment->slot->date.''.$appointment->slot->start_time.".";
        
       Helper::sendSMS($data);
       ///doctor sms
       $data['mobile'] = $appointment->doctor->mobile;
       $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an appointment cancelled with ". $appointment->Appointmentdetail->name ." on " .$appointment->slot->date.''.$appointment->slot->start_time.".";
       Helper::sendSMS($data);
   }
   public function send_user_appointmentupdate_sms($appointment){
        
    ///user sms
   $data['mobile'] = $appointment->Appointmentdetail->mobile;
   $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an appointment time change with ". $appointment->doctor->name." on " .$appointment->slot->date.''.$appointment->slot->start_time.".";
    
   Helper::sendSMS($data);
   ///doctor sms
   $data['mobile'] = $appointment->doctor->mobile;
   $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an appointment time change with ". $appointment->Appointmentdetail->name ." on " .$appointment->slot->date.''.$appointment->slot->start_time.".";
   Helper::sendSMS($data);
 }

   
}
