<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\SlotResource;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\Doctor\DoctorQuestionResource;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\AppointmentResource;
//use App\Http\Resources\User\UserQuestionResource;
use App\Model\UserQuestion;
use App\Model\UserAdditionalQuestion;
use App\Model\Slot;
use App\Model\DoctorDetails;
use App\Model\DoctorRates;
use App\Model\DoctorAdditionalQuestion;
use App\Model\DoctorQuestion;
use App\Model\Question;
use App\Doctor;
use App\Model\Someone_Appointment;
use App\Model\Someone_AppointmentDetail;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Validator;
use Storage;
use DB;
use Illuminate\Support\Str;

class SomeoneController extends Controller
{
  /* public function upload_prescription(Request $request)
    {

        $validator = Validator::make($request->all(),[
            'prescription' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('prescription');
            $path = Storage::put('uploads/prescriptions', $file);

            DoctorAdditionalQuestion::updateOrCreate([
                'doctor_id' => Auth::id(),
            ],[
                'prescription' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'Presciption Uploaded']);
    }*/

   /*   public function upload_lab_report(Request $request)
      {

        $validator = Validator::make($request->all(),[
            'report' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('report');
            $path = Storage::put('uploads/lab-reports', $file);

            DoctorAdditionalQuestion::updateOrCreate([
                'doctor_id' => Auth::id(),
            ],[
                'lab_reports' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'Doctor Lab Report Uploaded']);
    }*/


    public function create(Request $request){
        $user_id= Auth::id();
        $validator = Validator::make($request->all(),[
            'questions' => 'required', 'json',
            'allergies' => 'nullable',
            'ailments' => 'nullable',
            'slot_id' => 'required|exists:slots,id',
            'patient_name' => 'required|max:191',
            'gender' => 'required|numeric|min:1|max:3',
            'consultation_type' => 'required|numeric',
            'appoinment_type' => 'required|numeric',
            'age'=>'required|numeric',
            'complaints' => 'nullable',
            'ailments' => 'nullable',
            'questions' => 'required', 'json',
            'first_name' => 'required',
            'last_name' => 'required',
            'dob' => 'required',
            'prescription' => 'required|image',
            'lab_report' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }




        try{


          //  DB::beginTransaction();

            // Make Slot as Filled or if slot is already allocated then return error message
            $slot = Slot::where('status', 0)
                            ->whereId($request->slot_id)
                            ->first();
            if($slot){
                $slot->status = 1;
                $slot->save();
            }
            else{
                return response()->json(['status' => false, 'message' => 'slot already allocated']);
            }

            // Create appointment
            $appointment = Someone_Appointment::create([
                'appointment_no' => rand(10000000, 99999999),
                'slot_id' => $request->slot_id,
                'user_id' =>$user_id,
                'doctor_id' => $slot->doctor_id,
                'date'=>$request->date,
                'transaction_id' => $request->transaction_id,
                'total_amount' => $request->total_amount,
                'reason' => $request->reason,
                'transaction_type'=>1,
                'status' => 0,
            ]);



            $id=DB::getPdo()->lastInsertId();

            $user = new UserResource(Auth::user());
            $file = $request->file('prescription');
            $prescriptionpath = Storage::put('uploads/prescriptions', $file);
            $lab_reports = $request->file('lab_report');
            $reportpath = Storage::put('uploads/lab-reports', $lab_reports);
            // Create Appointment Details
            $appointment_details = array(
                'appointment_id' => $id,
                'name' => $request->patient_name,
                'gender' => $request->gender,
                'email' => $request->email,
                //'mobile' => $request->mobile,

                'consultation_type' => $request->consultation_type,
                'appoinment_type' => $request->appoinment_type,
                //'questions' => $request->questions,
                'dob' => $request->dob,
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'complaints' => $request->complaints,
                'ailments' => $request->ailments,
                'age' => $request->age,
                'prescription' => $prescriptionpath,
                'lab_reports' => $reportpath,

            );
            DB::table('someone__appointment_details')->insert($appointment_details);

           DB::beginTransaction();
            $questions = json_decode($request->questions, true);
           $appoinment_type = $request->appoinment_type;
            foreach ($questions as $key => $value) {

                if(!Question::find($key)){
                    return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => 'Invalid Question id '. $key]);
                }

                UserQuestion::updateOrCreate([
                    'someone_id' => $id,
                    'user_id' => $user_id,
                    'question_id' => $key,
                    'appoinment_type'=>$appoinment_type
                ],[
                    'answer' => $value
                ]);
            }

            UserAdditionalQuestion::updateOrCreate([
                'someone_id' =>$id,
                 'user_id' => $user_id,
            ],[
                'allergies' => $request->allergies,
                'ailments' => $request->ailments
            ]);
            DB::commit();


        }
        catch(\Exception $e){

            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
        }

        $data = new AppointmentResource($appointment);

        return response()->json(['status' => true, 'message' => 'Appointment Create', 'data' => $data]);
    }



     /* public function create2(Request $request){
        $validator = Validator::make($request->all(),[
            'slot_id' => 'required|exists:slots,id',
            'consultation_type' => 'required|numeric',
            'appoinment_type' => 'required|numeric',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try{

            DB::beginTransaction();

            // Make Slot as Filled or if slot is already allocated then return error message
            $slot = Slot::where('status', 0)
                            ->whereId($request->slot_id)
                            ->first();
            if($slot){
                $slot->status = 1;
                $slot->save();
            }
            else{
                return response()->json(['status' => false, 'message' => 'slot already allocated']);
            }
            // Create appointment
            $appointment = Appointment::create([
                'appointment_no' => rand(10000000, 99999999),
                'slot_id' => $request->slot_id,
                'user_id' => Auth::id(),
                'doctor_id' => $slot->doctor_id,
                'status' => 0,
            ]);


            $user = new UserResource(Auth::user());
            // Create Appointment Details
            $appointment_details = Someone_AppointmentDetail::create([
                'appointment_id' => $appointment->id,
                'name' => $user->name,
                'mobile' => $user->mobile,
                'email' => $user->email,
                'consultation_type' => $request->consultation_type,
                'appoinment_type' => $request->appoinment_type,
            ]);

            DB::commit();
        }
        catch(\Exception $e){

            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
        }

        $data = new AppointmentResource($appointment);

        return response()->json(['status' => true, 'message' => 'Appointment Create', 'data' => $data]);
    }*/
    public function sameone_appointments(Request $request){

        $today = Carbon::today()->toDateString();
        $type=2;

            //Upcoming Appointments

            $upcoming_appointments = Someone_Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '>=',$today);
                            })
                           /* ->whereHas('someone_appointment_details', function($query) use ($type){
                                $query->where('appoinment_type', '=',$type);
                            })*/
                            ->get();

            //Past Appointments

            $past_appointments = Someone_Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '<',$today);
                            })
                           /* ->whereHas('someone_appointment_details', function($query) use ($type){
                                $query->where('appoinment_type', '=',$type);
                            })*/
                            ->get();


        if($upcoming_appointments->isNotEmpty() || $past_appointments->isNotEmpty()){
            $data1 = AppointmentResource::collection($upcoming_appointments);
            $data2 = AppointmentResource::collection($past_appointments);
            $data=array("upcoming_appointments"=>$data1,"past_appointments"=>$data2);
            return response()->json(['status' => true, 'message' => 'Sameone Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


}
