<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\SlotResource;
use App\Model\Slot;
use Illuminate\Http\Request;
use Validator;

class SlotController extends Controller
{
    public function index(Request $request){
    	$validator = Validator::make($request->all(), [
    		'date' => 'required|date',
            'doctor_id' => 'required|exists:doctors,id',
    	]);

    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    	}

    	$date = date('Y-m-d', strtotime($request->date));

    	$slots = Slot::whereDoctorId($request->doctor_id)
                    ->where('date', $date);
                    if($request->type_time)
                    {
                    $slots->Where('type_time','=',$request->type_time);
                    }
    			 $slotdata	=$slots->get();
              
                $items = array();
                foreach($slotdata as $slot_key)
                { 
                                /* soni*/
                            $items[] = array(
                                'id' => $slot_key->id,
                                'doctor_id' => $slot_key->doctor_id ,
                                'date' => $slot_key->date,
                                'start_time' => date('h:i',strtotime($slot_key->start_time)),
                                'end_time' =>  date('h:i',strtotime($slot_key->end_time)),
                                'duration' => $slot_key->duration,
                                'type_time'=>$slot_key->type_time,
                                'status' => $slot_key->status,
                            );

            }
            $count= count($items);
        

    	if($count==0){
    		return response()->json(['status' => false, 'message' => 'No Containt Found']);

    	}
        else
        {

             return response()->json(['status' => true, 'message' => 'Slots of the doctor', 'data' => $items]);
        }

    }

}
