<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\AppointmentResource;
use App\Http\Resources\AppointmentResourceOne;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\User\UserResource;
use App\Model\Appointment;
use App\Model\AppointmentDetail;
use App\Model\Slot;
use App\Model\DoctorDetails;
use App\Model\DoctorRates;
use App\Model\UserWalletBalance;
use App\Doctor;
use App\User;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Validator;
use Storage;
use App\Helpers\Helper;
use Mail;

class AppointmentController extends Controller
{
    public function index(Request $request){
        $validator = Validator::make($request->all(),[
            'slug' => 'required|numeric|min:0|max:1',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        $today = Carbon::today()->toDateString();

        //Upcoming Appointments
        if($request->slug == 0){

            $appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '>=',$today);
                            })
                            ->orWhere('status', '!=', 3)
                            ->get();
        }
        else{
            $appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '=',$today);
                            })
                            ->orWhere('status', 3)
                            ->limit(1)
                            ->get();
        }

        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            return response()->json(['status' => true, 'message' => 'User Appointments', 'data' => $data]);
        }

        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function index_one(Request $request){

        
        $validator = Validator::make($request->all(),[
            'slug' => 'required|numeric|min:0|max:1',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        $today = Carbon::today()->toDateString();
        
        if($request->slug == 1){

            $appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '>=',$today);
                                $query->whereTime('start_time', '>=',date("h:i:s"));
                            })
                            ->orWhere('status', '!=', 3)
                            ->limit(1)
                            ->get();

        }
        else{
            $appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '=',$today);
                            })
                            ->orWhere('status', 3)
                            ->limit(1)
                            ->get();
        }


        //echo count($appointments);
       // dd($appointments);
        if($appointments->isNotEmpty()){
            $data = AppointmentResourceOne::collection($appointments);
            return response()->json(['status' => true, 'message' => 'User Appointments', 'data' => $data]);
        }
        else
        {
            $img=DB::table('user_details')->select('profile')->where('user_id',Auth::id())->get();
            $user=DB::table('users')->select('id')->limit(1)->first();
            $data[]= [
            'id' =>$user->id,
            'appointment_no' => '',
            'profile' =>$img[0]->profile,
            'status' => 0,
           // 'slot' => new SlotResource(Slot::find($this->slot_id)),
            'slot' =>array('message'=>"Slots unavailable"),
            'doctor' => DB::table('doctors')->limit(1)->first(),
            'total_price'=>0,
           // 'doctor_info' => DoctorDetails::whereDoctorId($this->slot->doctor_id)->get(),
            'doctor_rate' => DB::table('doctor_rates')->limit(1)->get()
        ];

            return response()->json(['status' => true, 'message' => 'User Appointments', 'data' => $data]);
        }

        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }

    public function create(Request $request){
    	$validator = Validator::make($request->all(),[
            'slot_id' => 'required|exists:slots,id',
            'patient_name' => 'required|max:191',
    		'gender' => 'required|numeric|min:1|max:3',
    		'consultation_type' => 'required|numeric',
    		'appoinment_type' => 'required|numeric',
            'age'=>'required|numeric',
    		'complaints' => 'nullable',
    		'ailments' => 'nullable',
    		'questions' => 'required', 'json',
            'first_name' => 'required',
            'last_name' => 'required',
            'dob' => 'required',
            'prescription' => 'required|image',
            'lab_report' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try{


        	DB::beginTransaction();

        	// Make Slot as Filled or if slot is already allocated then return error message
	    	$slot = Slot::where('status', 0)
	    					->whereId($request->slot_id)
	    					->first();
	    	if($slot){
	    		$slot->status = 1;
	    		$slot->save();
	    	}
	    	else{
	    		return response()->json(['status' => false, 'message' => 'slot already allocated']);
	    	}

        	// Create appointment
        	$appointment = Appointment::create([
	        	'appointment_no' => rand(10000000, 99999999),
	        	'slot_id' => $request->slot_id,
	        	'user_id' => Auth::id(),
                'doctor_id' => $slot->doctor_id,
                'status' => 0,
                'date'=>$request->date,
        	]);


            $user = new UserResource(Auth::user());
            $file = $request->file('prescription');
            $prescriptionpath = Storage::put('uploads/prescriptions', $file);
            $lab_reports = $request->file('lab_report');
            $reportpath = Storage::put('uploads/lab-reports', $lab_reports);
    		// Create Appointment Details
	    	$appointment_details = AppointmentDetail::create([
	    		'appointment_id' => $appointment->id,
	    		'name' => $request->patient_name,
	    		'gender' => $request->gender,
	    		//'blood_group' => $request->blood_group,
	    		'mobile' => $user->mobile,
	    		'email' => $user->email,
                'consultation_type' => $request->consultation_type,
                'appoinment_type' => $request->appoinment_type,
                'questions' => $request->questions,
                'dob' => $request->dob,
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'complaints' => $request->complaints,
                'ailments' => $request->ailments,
                'age' => $request->age,
                'prescription' => $prescriptionpath,
                'lab_reports' => $reportpath,
	    		//'height' => $request->height,
	    		//'weight' => $request->weight,
	    		//'previous_report' => $request->previous_report,
	    		//'any_medication' => $request->any_medication,
	    		//'any_allergy' => $request->any_allergy,
	    	]);

	    	DB::commit();
        }
        catch(\Exception $e){

        	DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
        }

        $data = new AppointmentResource($appointment);

        return response()->json(['status' => true, 'message' => 'Appointment Create', 'data' => $data]);
    }


    public function create2(Request $request){
       
          
           
        $validator = Validator::make($request->all(),[
            'slot_id' => 'required|exists:slots,id',
            'consultation_type' => 'required|numeric',
            'appoinment_type' => 'required|numeric',
        ]);
         
        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try{

            DB::beginTransaction();

            // Make Slot as Filled or if slot is already allocated then return error message
            $slot = Slot::where('status', 0)
                            ->whereId($request->slot_id)
                            ->first();
            if($slot){
                $slot->status = 1;
                $slot->save();
            }
            else{
                return response()->json(['status' => false, 'message' => 'slot already allocated']);
            }
            // Create appointment
            $appointment = Appointment::create([
                'appointment_no' => rand(10000000, 99999999),
                'slot_id' => $request->slot_id,
                'user_id' => Auth::id(),
                'doctor_id' => $slot->doctor_id,
                'transaction_id' => $request->transaction_id,
                'total_amount' => $request->total_amount,
                'reason' => $request->reason,
                'transaction_type'=>1,
                'status' => 0,
            ]);

            
            $user = new UserResource(Auth::user());
            // Create Appointment Details
            $appointment_details = AppointmentDetail::create([
                'appointment_id' => $appointment->id,
                'name' => $user->name,
                'mobile' => $user->mobile,
                'email' => $user->email,
                'consultation_type' => $request->consultation_type,
                'appoinment_type' => $request->appoinment_type,
            ]);

            $data =Appointment::with('Appointmentdetail','doctor')->where('id',$appointment->id)->first();
           $this->send_user_appointment_sms($data);

            DB::commit();
            if($request->transaction_id=='wallet')
            {
               $wallet=new UserWalletBalance;
               $wallet->user_id=Auth::id()?Auth::id():0;
               $wallet->doctor_id=($slot->doctor_id)? $slot->doctor_id:0;
               $wallet->transaction_id=$request->transaction_id;
               $wallet->payment_type='debit';
               $wallet->amount=$request->total_amount;
               $wallet->appointment_type='Accept';
               $wallet->save();

            }
         
            Helper::Firebasedata('Appointmentbooking',$appointment);
        }
        catch(\Exception $e){

            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
        }

        $data = new AppointmentResource($appointment);
       // echo $data->doctor;
       // dd();
        ///send sms to user and doctor 
       $data =Appointment::with('Appointmentdetail','doctor','slot')->where('id',$appointment->id)->first();
       $this->send_user_appointment_sms($data);
       //$this->send_user_email($data);

        return response()->json(['status' => true, 'message' => 'Appointment Create',
         'data' => $data]);
    }


    public function get_doctor_info(Request $request){


        $validator = Validator::make($request->all(),[
            'doctor_id' => 'required|numeric',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        $doctor_info = DoctorDetails::find($request->doctor_id);
        if($doctor_info){
            //$data = UserQuestionResource::collection($user_question);
            $data1= new DoctorResource(Doctor::find($request->doctor_id));
            $doctor_rates = DoctorRates::find($request->doctor_id);
            $data = array("profile"=>$data1,"doctor_info"=>$doctor_info,"rates"=>$doctor_rates);
            return response()->json(['status' => true, 'message' => 'Doctor Info','data' => $data]);
        }

        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function myappointments(Request $request){

        $today = Carbon::today()->toDateString();
        $type=1;

            //Upcoming Appointments

            $upcoming_appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '>=',$today);
                            })
                            ->whereHas('appointment_details', function($query) use ($type){
                                $query->where('appoinment_type', '=',$type);
                            })
                            
                             ->where('status','!=',4)
                             ->where('status','!=',2)
                            ->get();

            //Past Appointments

            $past_appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '<',$today);
                            })
                            ->whereHas('appointment_details', function($query) use ($type){
                                $query->where('appoinment_type', '=',$type);
                            })
                            ->get();


        if($upcoming_appointments->isNotEmpty() || $past_appointments->isNotEmpty()){
            $data1 = AppointmentResource::collection($upcoming_appointments);
            $data2 = AppointmentResource::collection($past_appointments);
            $data=array("upcoming_appointments"=>$data1,"past_appointments"=>$data2);
            return response()->json(['status' => true, 'message' => 'User Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function others_appointments(Request $request){

        $today = Carbon::today()->toDateString();
        $type=2;

            //Upcoming Appointments

            $upcoming_appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '>=',$today);
                            })
                            ->whereHas('appointment_details', function($query) use ($type){
                                $query->where('appoinment_type', '=',$type);
                            })
                            ->get();

            //Past Appointments

            $past_appointments = Appointment::whereUserId(Auth::id())
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '<',$today);
                            })
                            ->whereHas('appointment_details', function($query) use ($type){
                                $query->where('appoinment_type', '=',$type);
                            })
                            ->get();


        if($upcoming_appointments->isNotEmpty() || $past_appointments->isNotEmpty()){
            $data1 = AppointmentResource::collection($upcoming_appointments);
            $data2 = AppointmentResource::collection($past_appointments);
            $data=array("upcoming_appointments"=>$data1,"past_appointments"=>$data2);
            return response()->json(['status' => true, 'message' => 'Others Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
     public function user_update_email(Request $request)
    {
        try {
            $email=$request->email;
            $email_all=DB::table('users')->select('email')->where('email',$email)->get();
            $n=count($email_all);
           // echo $n;
           // dd();
            if($n == 0)
            {
                $email_data = array('email' => $email);
                $email_update= DB::table('users')
                  ->where('id',Auth::id())
                  ->update($email_data);
            }
            else
            {
                return response()->json(['status' => false, 'message' => 'Email already exists']);
            }


          }


      catch (Exception $e) {
          return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
      }
         return response()->json(['status' => true, 'message' => 'Update Email']);
    }
    public function user_email()
    {
        \Mail::send([], [], function ($message) {
            $message->to('developer44@indglobal-consulting.com', 'John Doe')
                ->subject('Welcome!')
                ->setBody('<h1>Hi, welcome user!</h1>', 'text/html');
        });
       //https://github.com/Bogardo/Mailgun
       //https://medium.com/@OlabodeAbesin/how-to-send-emails-with-mailgun-in-laravel-easy-in-4-steps-451ebc1c5574
    }
   public function Cancelappointments()
   {
       
        try {
                    
            // $data= DB::table('appointments')
            // ->join('slots', 'appointments.slot_id', '=', 'slots.id')
            // ->join('appointment_details','appointment_details.appointment_id','appointments.id')
            // ->join('doctors','doctors.id','appointments.doctor_id')
            // ->where('appointments.user_id',Auth::id()) 
            // ->where('appointments.status','=',4) 
            // ->orderby('slots.id','ASC')
            // ->select('slots.*',
            // 'appointments.appointment_no',
            // 'appointments.doctor_id',
            // 'appointment_details.consultation_type',
            // 'appointment_details.consultation_type',
            // 'appointment_details.appoinment_type',
            // 'doctors.name as doctor_name',
            // 'doctors.mobile as doctor_mobile' )
            // ->get();

            $data=Appointment::with('doctor','slot','appointment_details')
              ->where('appointments.status','=',4)
              ->where('appointments.user_id',Auth::id())->get();  
            
        }


            catch (Exception $e) {
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
                return response()->json(['status' => true, 'message' => 'Cancel appointments','data'=>$data]);

    }

    public function send_user_appointment_sms($appointment){
        
         ///user sms
        if($appointment->Appointmentdetail->mobile)
        {
         $consultation= $appointment->Appointmentdetail->consultation_type;
         $consultation=($consultation=1)?'Online Consultation ':'Offline Consultation ';   
        $data['mobile'] = $appointment->Appointmentdetail->mobile;
        $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an ".$consultation. "appointment booked with ". $appointment->doctor->name." on " .date('d-m-Y',strtotime($appointment->slot->date)).' '.$appointment->slot->start_time.".";
         
        Helper::sendSMS($data);
        }
        ///doctor sms
        if($appointment->doctor->mobile)
        {
         $consultation= $appointment->Appointmentdetail->consultation_type;
         $consultation=($consultation=1)?'Online Consultation ':'Offline Consultation ';
         $data['mobile'] = $appointment->doctor->mobile;
         $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an ".$consultation." appointment booked with ". $appointment->Appointmentdetail->name ." on " .date('d-m-Y',strtotime($appointment->slot->date)).' '.$appointment->slot->start_time.".";
        Helper::sendSMS($data);
      }
    }

    public function send_user_email($user)
    {
        if($user->Appointmentdetail->email)
        {
            Mail::send('email.usermail', ['user' => $user], function ($m) use ($user) {
                $m->from('nikhil@elixirhealth.in', 'Your Elixer');
    
                $m->to($user->Appointmentdetail->email, $user->Appointmentdetail->name)->subject('Elixer Appointment');
            });
        }
        
        if($user->doctor->email)
        {
            Mail::send('email.doctormail', ['user' => $user], function ($m) use ($user) {
                $m->from('nikhil@elixirhealth.in', 'Your Elixer');
                $m->to($user->doctor->email, $user->doctor->name)->subject('Elixer Appointment');
            });
        }
       

    }


     

}
