<?php

namespace App\Http\Controllers\Api\Doctor;

use App\Http\Controllers\Controller;
use App\Http\Resources\Doctor\AppointmentResource;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\User\UserResource;
use App\Model\Appointment;
use App\Model\AppointmentDetail;
use App\Model\Slot;
use App\Model\DoctorDetails;
use App\Model\DoctorRates;
use App\Model\AppointmentLogs;
use App\Model\UserAdditionalQuestion;
use App\Http\Resources\User\UserQuestionResource;
use App\Doctor;
use App\Model\Question;
use App\Model\DiagnosisNote;
use App\Model\User;
use App\Model\UserDetail;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Validator;
use Storage;
use App\Helpers\Helper;
use App\Model\ClinicalNote;

use App\Model\UserPrescriptions;
use App\Model\UserLabReports;
use App\Model\UserQuestion;

class AppointmentController extends Controller
{
    public function index(Request $request){
        $appointments = Appointment::whereDoctorId(Auth::id())
                            ->get();
        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            return response()->json(['status' => true, 'message' => 'User Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function get_someone_else()
    {
        $data=DB::table('someone__appointments')
        ->leftjoin('someone__appointment_details','someone__appointment_details.appointment_id','=','someone__appointments.id')
        ->get();
        return response()->json(['status' => true, 'message' => 'Someone Appointments', 'data' => $data]);
    }


    public function newappointments(Request $request){

        $appointments = Appointment::whereDoctorId(Auth::id())
                            ->Where('status', '=', 0)
                            ->get();

        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            return response()->json(['status' => true, 'message' => 'New Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function upcomming_appointments(Request $request){

        // $appointments = Appointment::whereDoctorId(Auth::id())
        //                     ->Where('status', '=', 1)

        //                     ->orderby('date','DESC')
        //                     ->get();
          date_default_timezone_set('Asia/Kolkata');
          $today = Carbon::today()->toDateString();
                 $appointments =Appointment::join('slots','slots.id','appointments.slot_id')
	                         ->Where('appointments.status', '=', 1)
	                         ->Where('appointments.doctor_id', '=', Auth::id())
	                         ->whereDate('slots.date', '>=',$today)
				             ->whereTime('slots.start_time', '>=',date("H:i:s"))
				              ->select('appointments.*')
				              ->orderby('slots.date','DESC')
				             ->get();
				  //dd($appointments ,$data);
        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            $data->sortByDesc(function ($data, $key) {
                return $data['slot']['date'];
            });
            return response()->json(['status' => true, 'message' => 'Upcomming Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function completed_appointments(Request $request){

        $appointments = Appointment::whereDoctorId(Auth::id())
                            ->Where('status', '=', 3)
                            ->get();
        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            return response()->json(['status' => true, 'message' => 'Completed Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }

    public function cancelled_appointments(Request $request){

        $appointments = Appointment::whereDoctorId(Auth::id())
                            ->Where('status', '=', 4)
                            ->get();
        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            
            return response()->json(['status' => true, 'message' => 'Cancelled Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function rescheduled_appointments(Request $request){
        
        $appointments = Appointment::whereDoctorId(Auth::id())
                            ->Where('status', '=', 5)
                            ->get();
        
        if($appointments->isNotEmpty()){
            $data = AppointmentResource::collection($appointments);
            return response()->json(['status' => true, 'message' => 'Rescheduled Appointments', 'data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function update_appointment(Request $request){

    	$validator = Validator::make($request->all(),[
            'status' => 'required|numeric',
            'appointment_id' => 'required|numeric',
        ]);
        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }
        $appointments = Appointment::whereId($request->appointment_id)
                            ->get();
        if($appointments->isEmpty()){
            return response()->json(['status' => false, 'message' => 'No Containt Found']);
        }

		try{


			DB::beginTransaction();
			$appointment=Appointment::updateOrCreate([
			    'id' => $request->appointment_id
			],[
			    'status' => $request->status
			]);

             if($request->status==1){ $log = 'Appointment Accepted'; }
             else if($request->status==2){$log = 'Appointment Rejected';}
             else if($request->status==3){$log = 'Appointment Completed';}
             else if($request->status==4){$log = 'Appointment Cancelled';}

			// Create Appointment Details
			 $appointment_logs = AppointmentLogs::Create([
				'appointment_id' => $request->appointment_id,
				'user_id' => Auth::id(),
				'log' => $log,
            ]);
            if($request->status==4 || $request->status==2)
            {
                $rsdata =Appointment::with('Appointmentdetail','doctor','slot')->where('id',$request->appointment_id)->first();
                $this->send_user_appointment_sms($rsdata);
            }
            
            DB::commit();
             
            $data = Appointment::whereId($request->appointment_id)
                            ->first();
             Helper::Firebasedata('RescheduleAppointment',$data);
		}
		catch(\Exception $e){

			DB::rollback();
			return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
		}
        $data = new AppointmentResource($appointment);
        return response()->json(['status' => true, 'message' => 'Appointment Status Updated', 'data' => $data]);
    }
    public function get_all_appointment()
    {
        $data =DB::table('appointments')
        ->leftjoin('users','users.id','=','appointments.user_id')
        ->leftjoin('user_details','user_details.user_id','=','users.id')
        ->where('appointments.doctor_id',Auth::id())
        ->get();
        return response()->json(['status' => true, 'message' => 'Appointment List', 'data' => $data]);
    }
    public function getprescriptions(Request $request){
        $user_id=$request->user;

        $patient_prescriptions = UserPrescriptions::whereUserId($user_id)
        ->orderBy('created_at','DESC')
        ->get();


        if($patient_prescriptions->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Prescriptions', 'data' => $patient_prescriptions]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function getlabreports(Request $request){
        $user_id=$request->user;
        $patient_labreports = UserLabReports::whereUserId($user_id)
        ->orderBy('created_at','DESC')
        ->get();
        //dd(Auth::id());
        if($patient_labreports->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Lab Reports', 'data' => $patient_labreports]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function gethelthdetails(Request $request){
        $user_id=$request->user;
        $patient_labreports = UserLabReports::whereUserId($user_id)
        ->orderBy('created_at','DESC')
        ->get();
        $helthdetails = DB::table('questions')
        ->join('user_questions', 'user_questions.question_id', '=', 'questions.id')
        ->select('questions.question','user_questions.answer','questions.id','user_id')
        ->whereUserId($user_id)
        ->get();

        if($helthdetails->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'User Helth Details', 'data' => $helthdetails]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }
    public function patient_info(Request $request)
    {
        $user_id=$request->user;
        $patient_labreports = UserLabReports::whereUserId($user_id)
        ->orderBy('created_at','DESC')
        ->get();
        $patient_prescriptions = UserPrescriptions::whereUserId($user_id)
        ->orderBy('created_at','DESC')
        ->get();
        $questionsdetails = DB::table('questions')
        ->join('user_questions', 'user_questions.question_id', '=', 'questions.id')
        ->select('questions.question','user_questions.answer','questions.id','user_id')
        ->whereUserId($user_id)
        ->get();
        $userdetails = DB::table('users')
        ->join('user_details', 'user_details.user_id', '=', 'users.id')
        ->selectRaw("TIMESTAMPDIFF(YEAR,user_details.dob,CURDATE()) as age,users.*,user_details.*")
        ->whereUserId($user_id)
        ->get();
        $slot= DB::table('appointments')
            ->join('slots', 'slots.id', '=', 'appointments.slot_id')
            ->where('appointments.user_id',$user_id)
            ->orderBy('slots.id', 'desc')
            ->take(1)
            ->get();

        $count_lab=count($patient_labreports);
        $count_prescriptions=count($patient_prescriptions);
        $count_questionsdetails=count($questionsdetails);
        $count_userdetails=count($userdetails);
       $DiagnosisNote= DiagnosisNote::where('user_id',$user_id)->take(1)->first();
        $data=array(
            'userdetails'=>$userdetails,
            'patient_prescriptions' => $patient_prescriptions,
            'patient_labreports'=>$patient_labreports,
            'questionsdetails'=>$questionsdetails,
            'slot'=>$slot,
            'DiagnosisNote'=>$DiagnosisNote

        );
       // echo count($data);
       // dd();

       if($count_lab== 0 && $count_prescriptions== 0 && $count_questionsdetails == 0 && $count_userdetails == 0) {
        return response()->json(['status' => false, 'message' => 'No Containt Found']);

        } else {
            return response()->json(['status' => true, 'message' => 'User Details', 'data' => $data]);
        }
       // if($data->isEmpty()){
           // return response()->json(['status' => true, 'message' => 'User Details', 'data' => $data]);
       // }
       //
    }
    public function doctor_online_status(Request $request)
    {
        $doctor_id=$request->doctor_id;
        $status=$request->status;

        $docto_data=array('online_status' =>$status );

        if($doctordetails = DB::table('doctors')->where('id',$doctor_id)->update($docto_data))
        {
             return response()->json(['status' => true, 'message' => 'Doctor Online Status', 'data' => $doctordetails]);
        }
        else
        {
            return response()->json(['status' => false, 'message' => 'Not Update  Online Status', 'data' => $doctordetails]);
        }
 }
 public function all_patient()
    {
        $all_patients=DB::table('users')
        ->join('user_details', 'user_details.user_id', '=', 'users.id')
        ->get();
        if($all_patients->isNotEmpty()){
            return response()->json(['status' => true, 'message' => 'Patient Details', 'data' => $all_patients]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);

    }
    public function update_rescheduled_appointment(Request $request)
    {

        $validator = Validator::make($request->all(),[
            'slot_id' => 'required|numeric',
            'appointment_id' => 'required|numeric',
        ]);
        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }
        $appointments = Appointment::whereId($request->appointment_id)
                            ->get();
        if($appointments->isEmpty()){
            return response()->json(['status' => false, 'message' => 'No Containt Found']);
        }

        try{


            DB::beginTransaction();
            $appointment=Appointment::updateOrCreate([
                'id' => $request->appointment_id
            ],[
                'slot_id' => $request->slot_id
            ]);
            $slot=Slot::find($request->slot_id);
            $slot->status=1;
            $slot->save();
           //dd($appointment);
             /*if($request->status==1){ $log = 'Appointment Accepted'; }
             else if($request->status==2){$log = 'Appointment Rejected';}
             else if($request->status==3){$log = 'Appointment Completed';}
             else if($request->status==4){$log = 'Appointment Cancelled';}

            // Create Appointment Details
             $appointment_logs = AppointmentLogs::Create([
                'appointment_id' => $request->appointment_id,
                'user_id' => Auth::id(),
                'log' => $log,
            ]); */

            DB::commit();
            $rsdata =Appointment::with('Appointmentdetail','doctor','slot')->where('id',$request->appointment_id)->first();
            $this->send_user_appointmentupdate_sms($rsdata);
        }
        catch(\Exception $e){

            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
        }
        $data = new AppointmentResource($appointment);
        return response()->json(['status' => true, 'message' => 'Appointment Status Updated', 'data' => $data]);
    }

   public function UserRegister(Request $request)
   {
      
        $validator = Validator::make($request->all(),[
            'name' => 'required|max:191',
            'email' => 'required|email|max:191|unique:users,email,',
            'dob' => 'required|date|before_or_equal:today',
            'gender' => 'required|numeric|min:1|max:3',
            'mobile' => 'required|unique:users,mobile',
            'user_elixir_id' => 'required|unique:users,user_elixir_id',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

    try{

        DB::beginTransaction();
            $image = $request->file('profile');
            $path='';
            if($image)
            {
            
                $path = Storage::put('uploads/profile', $request->file('profile'));
                
            }else{
                $path='';
                
            }
            $obj= new User;
            $obj->user_elixir_id=$request->user_elixir_id;
            $obj->name=$request->name;
            $obj->mobile=$request->mobile ;
            $obj->email=$request->email;
            $obj->save();
            $userid=$obj->id;
            $obj2=new UserDetail;
            $obj2->user_id=$userid;
            $obj2->dob=$request->dob;
            $obj2->gender=$request->gender;
            $obj2->profile=$path;
            $obj2->save();
         

        DB::commit();
    }
    catch(\Exception $e){

        DB::rollback();
        return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
    }
     
    return response()->json(['status' => true, 'user' =>$obj,'userdetail'=>$obj2]);
   }


   public function medical_info(Request $request){
            
            $validator = Validator::make($request->all(),[
                'questions' => 'required', 'json',
                'allergies' => 'nullable',
                'ailments' => 'nullable',
                'user_id'=>'required',
                
            ]);

            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }

            try {
                DB::beginTransaction();
                $questions = json_decode($request->questions, true);
                $appoinment_type = $request->appoinment_type;
                UserQuestion::where('user_id',$request->user_id)->delete();
                foreach ($questions as $key => $value) {

                    if(!Question::find($key)){
                        return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => 'Invalid Question id '. $key]);
                    }

                    UserQuestion::updateOrCreate([
                        'user_id' => $request->user_id,
                        'question_id' => $key,
                        'appoinment_type'=>$appoinment_type
                    ],[
                        'answer' => $value
                    ]);
                }

                UserAdditionalQuestion::updateOrCreate([
                    'user_id' => $request->user_id,
                ],[
                    'allergies' => $request->allergies,
                    'ailments' => $request->ailments
                ]);
                DB::commit();
            }
            catch (Exception $e) {
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }

            return response()->json(['status' => true, 'message' => 'User Question Updated']);
     }

        public function get_medical_info(){

            $user_question = UserQuestion::whereUserId($request->user_id)->get();

            if($user_question->isNotEmpty()){
                $data = UserQuestionResource::collection($user_question);
                return response()->json(['status' => true, 'message' => 'User Question', 'data' => $data]);
            }

            return response()->json(['status' => false, 'message' => 'No Containt Found']);
        }

        public function prescription_create(Request $request){
            $validator = Validator::make($request->all(),[
                'prescription' => 'required|image',
                'user_id'=>'required',
            ]);
    
            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
    
            // Database Operation
            try {
    
                $file = $request->file('prescription');
                $appoinment_type = $request->appoinment_type;
                $date = $request->date;
                $path = Storage::put('uploads/prescriptions', $file);
                DB::beginTransaction();
    
                UserPrescriptions::Create([
                    'user_id' => $request->user_id,
                    'prescription' => $path,
                    'appoinment_type'=> $appoinment_type,
                    'date'=> $date,
                ]);
    
                DB::commit();
            }
            catch (Exception $e) {
                DB::rollback();
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
            return response()->json(['status' => true, 'message' => 'Presciption Uploaded']);
        }
         
        public function prescriptionupdate(Request $request){
            $validator = Validator::make($request->all(),[
                'id'=>'required',
                'user_id'=>'required',

            ]);
    
            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
    
            // Database Operation
            try {
                DB::beginTransaction();
    
                $file = $request->file('prescription');
                $path='';
                if($request->file('prescription'))
                {
                    $path = Storage::put('uploads/prescriptions', $file);
                }

                $obj= UserPrescriptions::find($request->id);
                if($obj)
                {
                    $obj->prescription=($path)? $path: $obj->prescription;
                    $obj->save();
                }else{
                    return response()->json(['status' => false, 'message' => 'Presciption not found']);
                }
                
    
                DB::commit();
            }
            catch (Exception $e) {
                DB::rollback();
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
            return response()->json(['status' => true, 'message' => 'Presciption updated','data'=>$obj]);
        }

        public function labreportsupdate(Request $request){
            
            $validator = Validator::make($request->all(),[
                'id'=>'required',
                'user_id'=>'required',

            ]);
    
            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
    
            // Database Operation
            try {
                DB::beginTransaction();
    
                $file = $request->file('lab_reports');
                $path='';
                if($request->file('lab_reports'))
                {
                    $path = Storage::put('uploads/lab-reports', $file);
                }
               
                $obj= UserLabReports::find($request->id);
                
                if($obj)
                {
                    $obj->lab_reports=($path)? $path: $obj->lab_reports;
                    $obj->save();
                }else{
                    return response()->json(['status' => false, 'message' => 'Lab report not found']);
                }
               
    
                DB::commit();
            }
            catch (Exception $e) {
                DB::rollback();
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
            return response()->json(['status' => true, 'message' => 'Lab Report updated','data'=>$obj]);
        }


        public function labreports_create(Request $request){
            $validator = Validator::make($request->all(),[
                'lab_reports' => 'required|image',
                'user_id'=>'required',
            ]);
    
            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
    
            // Database Operation
            try {
    
                $file = $request->file('lab_reports');
                $appoinment_type = $request->appoinment_type;
                $date = $request->date;
                $path = Storage::put('uploads/lab-reports', $file);
                DB::beginTransaction();
    
                UserLabReports::Create([
                    'user_id' => $request->user_id,
                    'lab_reports' => $path,
                    'appoinment_type'=>$appoinment_type,
                    'date'=>$date
                ]);
    
                DB::commit();
            }
            catch (Exception $e) {
                DB::rollback();
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
            return response()->json(['status' => true, 'message' => 'Lab Reports Uploaded']);
        }


     public function ClinicalNote(Request $request){
            $validator = Validator::make($request->all(),[
                'user_id' => 'required',
                'doctor_id'=>'required',
                'notes'=>'required',
            ]);
    
            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
    
            // Database Operation
            try {
    
               
                DB::beginTransaction();
    
                ClinicalNote::Create([
                    'user_id' => $request->user_id,
                    'doctor_id' => $request->doctor_id,
                    'notes'=>$request->notes,
                ]);
    
                DB::commit();
            }
            catch (Exception $e) {
                DB::rollback();
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }
            return response()->json(['status' => true, 'message' => 'Notes Created']);
        }
    public function Getnotes(Request $request)
      {
        $validator = Validator::make($request->all(),[
            'user_id' => 'required',
            'doctor_id'=>'required',
             
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }
        
        $data = ClinicalNote::whereUserId($request->user_id)->whereDoctorId($request->doctor_id)->get();

        if($data->isNotEmpty()){
             
            return response()->json(['status' => true, 'message' => 'User Question', 'data' => $data]);
        }

        return response()->json(['status' => false, 'message' => 'No Containt Found']);

      }

      public function send_user_appointment_sms($appointment){
        
        ///user sms
       $data['mobile'] = $appointment->Appointmentdetail->mobile;
       $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an appointment cancelled with ". $appointment->doctor->name." on " .date('d-m-Y',strtotime($appointment->slot->date)).'  '.$appointment->slot->start_time.".";
        
       Helper::sendSMS($data);
       ///doctor sms
       $data['mobile'] = $appointment->doctor->mobile;
       $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an appointment cancelled with ". $appointment->Appointmentdetail->name ." on " .date('d-m-Y',strtotime($appointment->slot->date)).'  '.$appointment->slot->start_time.".";
       Helper::sendSMS($data);
   }

   public function send_user_appointmentupdate_sms($appointment){
        
    ///user sms
   $data['mobile'] = $appointment->Appointmentdetail->mobile;
   $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an appointment time change with ". $appointment->doctor->name." on " .date('d-m-Y',strtotime($appointment->slot->date)).'   '.$appointment->slot->start_time.".";
    
   Helper::sendSMS($data);
   ///doctor sms
   $data['mobile'] = $appointment->doctor->mobile;
   $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an appointment time change with ". $appointment->Appointmentdetail->name ." on " .date('d-m-Y',strtotime($appointment->slot->date)).'  '.$appointment->slot->start_time.".";
   Helper::sendSMS($data);
 }

}
