<?php

namespace App\Http\Controllers\Api\Assistantdoctor;

use App\Http\Controllers\Controller;
use App\Http\Resources\SlotResource;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\Doctor\DoctorQuestionResource;
use App\Model\Slot;
use App\Model\DoctorDetails;
use App\Model\DoctorQuestion;
use App\Model\DoctorRates;
use App\Doctor;
use App\Model\Appointment;
use App\Model\Assistantdoctor;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Validator;
use Storage;
use App\Model\DoctorAdditionalQuestion;
use DB;

use Illuminate\Support\Str;
class SlotController extends Controller
{
    public function index(Request $request){
        $DOCTORID= $this->getDoctorid();
    	$validator = Validator::make($request->all(), [
    		'date' => 'required|date',
    	]);

    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    	}
         
    	$date = date('Y-m-d', strtotime($request->date));

            $slots = DB::table('slots')
                    ->where('doctor_id',$DOCTORID)
                    ->where('date',$date);
                    if($request->type_time)
                    {
                    $slots->Where('type_time','=',$request->type_time);
                    }
                    $slotsdata=$slots->get();
                    
                    $items = array();
                    foreach($slotsdata as $slot_key)
                    {        
                           
                                $items[] = array(
                                    'id' => $slot_key->id,
                                    'doctor_id' => $slot_key->doctor_id ,
                                    'date' => $slot_key->date,
                                    'start_time' => date('h:i',strtotime($slot_key->start_time)),
                                    'end_time' =>  date('h:i',strtotime($slot_key->end_time)),
                                    'duration' => $slot_key->duration,
                                    'type_time'=>$slot_key->type_time,
                                    'status' => $slot_key->status,
                                 );

                   }
                   $count= count($items);
                    

                    if($count==0){
                        return response()->json(['status' => false, 'message' => 'No Containt Found']);

                    }
                    else
                    {

                         return response()->json(['status' => true, 'message' => 'Slots of the doctor', 'data' => $items]);
                    }
    }

    public function create(Request $request){
        $DOCTORID= $this->getDoctorid();
    	$validator = Validator::make($request->all(),[
    		'date' => 'required|date|after_or_equal:today',
    		'start_time' => 'required|date_format:H:i|before:end_time',
    		'end_time' => 'required|date_format:H:i|after:start_time',
            'duration' => 'required|numeric',
            'type_time'=>'required'
    	]);
         
    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    	}
       $check =Slot::where('date',$request->date)->where('type_time',$request->type_time)->get();
       if(count($check)>0)
       {
        return response()->json(['status' => false, 'message' => 'Already Created']);
       }
    	try {
    		$start_time = strtotime($request->start_time);
	    	$end_time = strtotime($request->end_time);

	    	for($i = $start_time; $i < $end_time; $i = strtotime("+ $request->duration minutes", $i)){
                $endTime = strtotime("+$request->duration minutes", $i );
	    	    $batchdata[]=array('doctor_id' => $DOCTORID,
	    	    	'date' => $request->date,
	    	    	'start_time' => date('H:i', $i),
	    	    	'end_time' => date('H:i',$endTime),
                    'duration' => $request->duration,
                    'type_time' => $request->type_time,
                    'created_at' => now(),
                    'updated_at' => now(),
                );
            }
            Slot::insert($batchdata);
    	}
    	catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
    	}

    	return response()->json(['status' => true, 'message' => 'Slots Created']);
    }


    public function get_doctor_info(Request $request){
        
        date_default_timezone_set('Asia/Kolkata');
        $doctor_info = DoctorDetails::find(Auth::id());
        if($doctor_info){
            //$data = UserQuestionResource::collection($user_question);
            $data1= new DoctorResource(Doctor::find(Auth::id()));
            $doctor_rates = DoctorRates::find(Auth::id());

             $today = Carbon::today()->toDateString();


           //New Appointments
           $DOCTORID= $this->getDoctorid();
            $new_appointments = Appointment::whereDoctorId($DOCTORID)
                             ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '=',$today);
                            })
                            ->Where('status', '=', 0)
                            ->count();

            $upcoming_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '>=',$today)
                                      ->whereTime('start_time', '>=',date("H:i:s"))
                                      ->where('status', '=',1);
                                       
                            })
                            ->Where('status', '=', 1)
                            ->count();

            $completed_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->Where('status', '=', 3)
                                      ->count();
            $cancelled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->Where('status', '=', 4)
                                      ->count();

            $rescheduled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->Where('status', '=', 5)
                                      ->count();

            $data = array("profile"=>$data1,"doctor_info"=>$doctor_info,"rates"=>$doctor_rates,"new_appointments"=>$new_appointments,"upcoming_appointments"=>$upcoming_appointments,"completed_appointments"=>$completed_appointments,"cancelled_appointments"=>$cancelled_appointments,"rescheduled_appointments"=>$rescheduled_appointments);
            return response()->json(['status' => true, 'message' => 'Doctor Info','data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function view_ledger(Request $request){
        $DOCTORID= $this->getDoctorid();
        $doctor_info = DoctorDetails::find($DOCTORID);
        if($doctor_info){

             //today
             $today = Carbon::today()->toDateString();

             //this week
             $ts = strtotime($today);
             $start = (date('w', $ts) == 0) ? $ts : strtotime('last sunday', $ts);
             $week_start_date = date('Y-m-d', $start);
             $week_end_date = date('Y-m-d', strtotime('next saturday', $start));

             //this month
             $first_day_this_month = date('Y-m-01'); // hard-coded '01' for first day
             $last_day_this_month  = date('Y-m-t');


             //two months
             $first_day_last_month = date("Y-m-01",strtotime("-1 Months"));
             $last_day_this_month = date('Y-m-t');

             //three months
             $first_day_three_month = date("Y-m-01",strtotime("-2 Months"));
             $last_day_three_month = date('Y-m-t');



           //New Appointments

            $total_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '=',$today);
                            })
                            ->count();

            $week_total_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                $query->whereBetween('date', [$week_start_date, $week_end_date]);
                            })
                            ->count();

            $month_total_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                            })
                            ->count();

            $twomonth_total_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                            })
                            ->count();

            $threemonth_total_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                            })
                            ->count();


            $new_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '=',$today);
                             })
                            ->Where('status', '=', 0)
                            ->count();

            $week_new_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                $query->whereBetween('date', [$week_start_date, $week_end_date]);
                            })
                            ->Where('status', '=', 0)
                            ->count();

            $month_new_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                            })
                            ->Where('status', '=', 0)
                            ->count();

            $twomonth_new_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                            })
                            ->Where('status', '=', 0)
                            ->count();

            $threemonth_new_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                            })
                            ->Where('status', '=', 0)
                            ->count();


            $upcoming_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($today){
                                $query->whereDate('date', '=',$today);
                             })
                            ->Where('status', '=', 1)
                            ->count();

            $week_upcoming_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                $query->whereBetween('date', [$week_start_date, $week_end_date]);
                            })
                            ->Where('status', '=', 1)
                            ->count();

            $month_upcoming_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                            })
                            ->Where('status', '=', 1)
                            ->count();

            $twomonth_upcoming_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                            })
                            ->Where('status', '=', 1)
                            ->count();
            $threemonth_upcoming_appointments = Appointment::whereDoctorId($DOCTORID)
                            ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                            })
                            ->Where('status', '=', 1)
                            ->count();


            $completed_appointments = Appointment::whereDoctorId($DOCTORID)
                                    ->whereHas('slot', function($query) use ($today){
                                         $query->whereDate('date', '=',$today);
                                      })
                                      ->Where('status', '=', 3)
                                      ->count();

            $week_completed_appointments = Appointment::whereDoctorId($DOCTORID)
                                    ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                            $query->whereBetween('date', [$week_start_date, $week_end_date]);
                                     })
                                      ->Where('status', '=', 3)
                                      ->count();
            $month_completed_appointments = Appointment::whereDoctorId($DOCTORID)
                                    ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 3)
                                      ->count();
            $twomonth_completed_appointments = Appointment::whereDoctorId($DOCTORID)
                                    ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 3)
                                      ->count();

            $threemonth_completed_appointments = Appointment::whereDoctorId($DOCTORID)
                                    ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 3)
                                      ->count();

            $cancelled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($today){
                                         $query->whereDate('date', '=',$today);
                                      })
                                      ->Where('status', '=', 4)
                                      ->count();

            $week_cancelled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                            $query->whereBetween('date', [$week_start_date, $week_end_date]);
                                      })
                                      ->Where('status', '=', 4)
                                      ->count();
            $month_cancelled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 4)
                                      ->count();

            $twomonth_cancelled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 4)
                                      ->count();

            $threemonth_cancelled_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 4)
                                      ->count();


            $rescheduled_appointments = Appointment::whereDoctorId($DOCTORID)
                                       ->whereHas('slot', function($query) use ($today){
                                         $query->whereDate('date', '=',$today);
                                      })
                                       ->Where('status', '=', 5)
                                      ->count();

            $week_rescheduled_appointments = Appointment::whereDoctorId($DOCTORID)
                                       ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                            $query->whereBetween('date', [$week_start_date, $week_end_date]);
                                      })
                                       ->Where('status', '=', 5)
                                      ->count();
            $month_rescheduled_appointments = Appointment::whereDoctorId($DOCTORID)
                                       ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                                      })
                                       ->Where('status', '=', 5)
                                      ->count();

            $twomonth_rescheduled_appointments = Appointment::whereDoctorId($DOCTORID)
                                       ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                                      })
                                       ->Where('status', '=', 5)
                                      ->count();

            $threemonth_rescheduled_appointments = Appointment::whereDoctorId($DOCTORID)
                                       ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                                      })
                                       ->Where('status', '=', 5)
                                      ->count();

            $rejected_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($today){
                                         $query->whereDate('date', '=',$today);
                                      })
                                      ->Where('status', '=', 2)
                                      ->count();

            $week_rejected_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($week_start_date,$week_end_date){
                                            $query->whereBetween('date', [$week_start_date, $week_end_date]);
                                      })
                                      ->Where('status', '=', 2)
                                      ->count();

            $month_rejected_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($first_day_this_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_this_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 2)
                                      ->count();

            $twomonth_rejected_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($first_day_last_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_last_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 2)
                                      ->count();

            $threemonth_rejected_appointments = Appointment::whereDoctorId($DOCTORID)
                                      ->whereHas('slot', function($query) use ($first_day_three_month,$last_day_this_month){
                                            $query->whereBetween('date', [$first_day_three_month, $last_day_this_month]);
                                      })
                                      ->Where('status', '=', 2)
                                      ->count();

             $today = array("total_appointments"=>$total_appointments,"new_appointments"=>$new_appointments,"upcoming_appointments"=>$upcoming_appointments,"completed_appointments"=>$completed_appointments,"cancelled_appointments"=>$cancelled_appointments,"rescheduled_appointments"=>$rescheduled_appointments,"rejected_appointments"=>$rejected_appointments);

             $thisweek = array("total_appointments"=>$week_total_appointments,"new_appointments"=>$week_new_appointments,"upcoming_appointments"=>$week_upcoming_appointments,"completed_appointments"=>$week_completed_appointments,"cancelled_appointments"=>$week_cancelled_appointments,"rescheduled_appointments"=>$week_rescheduled_appointments,"rejected_appointments"=>$week_rejected_appointments);

             $thismonth = array("total_appointments"=>$month_total_appointments,"new_appointments"=>$month_new_appointments,"upcoming_appointments"=>$month_upcoming_appointments,"completed_appointments"=>$month_completed_appointments,"cancelled_appointments"=>$month_cancelled_appointments,"rescheduled_appointments"=>$month_rescheduled_appointments,"rejected_appointments"=>$month_rejected_appointments);

             $twomonths = array("total_appointments"=>$twomonth_total_appointments,"new_appointments"=>$twomonth_new_appointments,"upcoming_appointments"=>$twomonth_upcoming_appointments,"completed_appointments"=>$twomonth_completed_appointments,"cancelled_appointments"=>$twomonth_cancelled_appointments,"rescheduled_appointments"=>$twomonth_rescheduled_appointments,"rejected_appointments"=>$twomonth_rejected_appointments);

             $threemonths = array("total_appointments"=>$threemonth_total_appointments,"new_appointments"=>$threemonth_new_appointments,"upcoming_appointments"=>$threemonth_upcoming_appointments,"completed_appointments"=>$threemonth_completed_appointments,"cancelled_appointments"=>$threemonth_cancelled_appointments,"rescheduled_appointments"=>$threemonth_rescheduled_appointments,"rejected_appointments"=>$threemonth_rejected_appointments);


            $data = array("today"=>$today,"thisweek"=>$thisweek,"thismonth"=>$thismonth,"twomonths"=>$twomonths,"threemonths"=>$threemonths);
            return response()->json(['status' => true, 'message' => 'View Ledger','data' => $data]);
        }
        return response()->json(['status' => false, 'message' => 'No Containt Found']);
    }


    public function profile_upload(Request $request){
        $validator = Validator::make($request->all(),[
            'profile' => 'required',
        ]);
        $DOCTORID= $this->getDoctorid();
        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('profile');
            $path = Storage::put('uploads/profile', $file);

            DoctorDetails::updateOrCreate([
                'doctor_id' => Auth::id()
            ],[
                'profile' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        // User Resouce collection Instance.
        $doctor = new DoctorResource(Auth::user());
        return response()->json(['status' => true, 'message' => 'Profile Updated', 'data' => $doctor]);
    }


    public function update_basic_details(Request $request){
        $validator = Validator::make($request->all(),[
            'first_name' => 'required|max:191',
            'last_name' => 'required|max:191',
            'email' => 'required|email|max:191|unique:doctors,email,'.Auth::id(),
            'dob' => 'required|date|before_or_equal:today',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        // Database Operation
        try {

            $doctor = Doctor::with('doctor_details')
                        ->where('id', Auth::id())
                        ->first();
            if($doctor){
                $doctor->name = $request->first_name.' '.$request->last_name;
                $doctor->email = $request->email;
                $doctor->save();

                $doctor->doctor_details->DOB = $request->dob;
                $doctor->doctor_details->save();
            }

        }
        catch (Exception $e) {
            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        // User Resouce collection Instance.
        $doctor = new DoctorResource($doctor);
        return response()->json(['status' => true, 'message' => 'Doctor basic details updated', 'data' => $doctor]);
    }
    public function basic_details(Request $request)
    {
      $validator = Validator::make($request->all(),[
        'name' => 'required|max:191',
        'email' => 'required|email|max:191|unique:users,email,'.Auth::id(),
        'dob' => 'required|date|before_or_equal:today',
        'gender' => 'required|numeric|min:1|max:3',
      ]);

      if($validator->fails()){
        $errors = collect($validator->messages())->flatten()->toArray();
        return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
      }

      // Database Operation
      try {
        DB::beginTransaction();

        $user = new Doctor;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->save();

        DoctorDetails::updateOrCreate([
          'doctor_id' => $DOCTORID
        ],[
          'DOB' => date('Y-m-d', strtotime($request->dob)),
          'gender' => $request->gender,
        ]);

        DB::commit();
      }
      catch (Exception $e) {
        DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
      }

      // User Resouce collection Instance.
      $user = new DoctorResource($user);
      return response()->json(['status' => true, 'message' => 'Doctor basic details', 'data' => $user]);
    }
    public function upload_prescription(Request $request)
    {
        $doctor_id=$request->doctor_id;
        $validator = Validator::make($request->all(),[
            'prescription' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('prescription');
            $path = Storage::put('uploads/prescriptions', $file);

            DoctorAdditionalQuestion::updateOrCreate([
                'doctor_id' => Auth::id(),
            ],[
                'prescription' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'Presciption Uploaded']);
    }

      public function upload_lab_report(Request $request)
      {
        $doctor_id=$request->doctor_id;
        $validator = Validator::make($request->all(),[
            'report' => 'required|image',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try {
            $file = $request->file('report');
            $path = Storage::put('uploads/lab-reports', $file);

            DoctorAdditionalQuestion::updateOrCreate([
                'doctor_id' => $doctor_id,
            ],[
                'lab_reports' => $path
            ]);

        }
        catch (Exception $e) {
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'Doctor Lab Report Uploaded']);
    }

    public function doctor_medical_info(Request $request){
        //  dd($request->questions);
            $validator = Validator::make($request->all(),[
                'questions' => 'required', 'json',
                'allergies' => 'nullable',
                'ailments' => 'nullable',
            ]);

            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
            $DOCTORID= $this->getDoctorid();
            try {
                DB::beginTransaction();
                $questions = json_decode($request->questions, true);



                foreach ($questions as $key => $value) {

                    if(!Question::find($key)){
                        return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => 'Invalid Question id '. $key]);
                    }

                    DoctorQuestion::updateOrCreate([
                        'doctor_id' => $DOCTORID,
                        'question_id' => $key
                    ],[
                        'answer' => $value
                    ]);
                }

                DoctorAdditionalQuestion::updateOrCreate([
                    'doctor_id' => $DOCTORID,
                ],[
                    'allergies' => $request->allergies,
                    'ailments' => $request->ailments
                ]);
                DB::commit();
            }
            catch (Exception $e) {
                return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
            }

            return response()->json(['status' => true, 'message' => 'User Question Updated']);
        }

        public function get_medical_info(){
            $DOCTORID= $this->getDoctorid();
            $doctor_question = DoctorQuestion::whereDoctorId($DOCTORID)->get();

            if($doctor_question->isNotEmpty()){
                $data = DoctorQuestionResource::collection($doctor_question);
                return response()->json(['status' => true, 'message' => 'Doctor Question', 'data' => $data]);
            }

            return response()->json(['status' => false, 'message' => 'No Containt Found']);
        }

   
        public function assistanceDoctor(){

            $data=[];
            $assisdoctor = Assistantdoctor::where('doctor_id', Auth::id())
            ->select(DB::raw("(GROUP_CONCAT(doctor_assistance_id SEPARATOR ',')) as `doctor_assistance_id`"))
            ->first();
            if($assisdoctor)
            {
            $data=Doctor::whereIn('id',explode(',',$assisdoctor->doctor_assistance_id))->get();
            }
            if($data->isNotEmpty()){
                
                return response()->json(['status' => true, 'message' => 'Doctor Question', 'data' => $data]);
            }

            return response()->json(['status' => false, 'message' => 'No Containt Found']);
        }

        public function diagnosis(Request $request){
            $validator = Validator::make($request->all(),[
                'user_id' => 'required|numeric',
                'notes' => 'required',
            ]);
            if($validator->fails()){
                $errors = collect($validator->messages())->flatten()->toArray();
                return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
            }
            try{
                $DOCTORID= $this->getDoctorid();
           //DB::beginTransaction();
              $check=DiagnosisNote::where('user_id',$request->user_id)->first();
              
                if($check)
                {
                   
                    $DiagnosisNote=DiagnosisNote::find($check->id);
                }else{
                    $DiagnosisNote=new DiagnosisNote;
                }
                 
                $DiagnosisNote->user_id =$request->user_id;
                $DiagnosisNote->notes=$request->notes;
                $DiagnosisNote->doctor_id=$DOCTORID;
                $rs=$DiagnosisNote->save();
                
                //dd($rs);
                return response()->json(['status' => true, 'message' => 'Diagnosis Note Added','data' => $DiagnosisNote]);
                
                //DB::commit();
                
            }
            catch(\Exception $e){
                
                //DB::rollback();
                return response()->json(['status' => false, 'message' => 'Something Went Wrong','data' => $e]);
            }
             
        }

        public function getDoctorid()
        {
             $rr=DB::table('assistantdoctors')->where('doctor_assistance_id',Auth::id())->first();
               if($rr)
               {
                  return $rr->doctor_id;
               }else{
                  return $DOCTORID;
               }
            
        }
}
