<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\AppointmentReport;
use App\Model\UserWalletBalance;
use App\Model\Doctor;
use App\Model\User;
use DB;
class UserWalletController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=UserWalletBalance::with('Doctor','User')->get();
         
        return view('admin.wallet.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
        return view('admin.wallet.create',compact('doctor','user'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $obj=new  UserWalletBalance;
       $obj->doctor_id=$request->doctor_id;
       $obj->user_id=$request->user_id;
       $obj->payment_type=$request->payment_type;
       $obj->appointment_type=$request->appointment_type;
       $obj->amount=($request->amount)?$request->amount:0;
       $obj->transaction_id=time();
       $obj->save();
       return redirect()->route('wallet.index')->with('message','Money Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=UserWalletBalance::with('Doctor','User')->where('id',$id)->first();
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
        return view('admin.wallet.edit',compact('doctor','user','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $obj=UserWalletBalance::find($id);
        $obj->doctor_id=$request->doctor_id;
        $obj->user_id=$request->user_id;
        $obj->payment_type=$request->payment_type;
        $obj->appointment_type=$request->appointment_type;
        $obj->amount=($request->amount)?$request->amount:0;
        $obj->transaction_id=time();
        $obj->save();
        
        return redirect()->route('wallet.index')->with('message','Money Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $obj = UserWalletBalance::findOrFail($id);
         
        $obj->delete();
       
        return redirect()->route('wallet.index')->with('message','Data Deleted ');
    }

    public function massDestroy(Request $request)
    {
        
        if ($request->input('ids')) {
            $entries = UserWalletBalance::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
}
