<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use DB;
use Carbon\Carbon;
use Kreait\Firebase;
use Kreait\Firebase\Factory;
use Kreait\Firebase\ServiceAccount;
use App\User;
use App\Model\Appointment;
use App\Doctor;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Support\Collection;

class SmsCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Sms:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'send sms to use before 5 minutes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
         
        date_default_timezone_set('Asia/Kolkata');
       
        $today = Carbon::today()->toDateString();
         $start = date("H:i:s",strtotime('-10 minutes'));
         $end =date("H:i:s");
         $notification= DB::table('appointments')
        ->join('appointment_details','appointment_details.appointment_id','appointments.id')
        ->join('slots', 'appointments.slot_id', '=', 'slots.id')
        ->whereDate('slots.date', '=',$today)
        ->whereBetween('start_time',[$start,$end])
        ->where('appointments.status','!=',4)
        ->where('appointments.status','!=',2)
        ->where('appointments.status','=',1)
        ->where('slots.status','=',1)
        ->get();
        foreach ($notification as $key => $value) {
             $data =Appointment::with('Appointmentdetail','doctor','slot')->where('appointment_no',$value->appointment_no)->first();
              $this->send_user_appointment_sms($data);
          }
    }

    public function send_user_appointment_sms($appointment){
        
        ///user sms
       if($appointment->Appointmentdetail->mobile)
       {
        $consultation= $appointment->Appointmentdetail->consultation_type;
        $consultation=($consultation=1)?'Online Consultation ':'Offline Consultation ';
       $data['mobile'] = $appointment->Appointmentdetail->mobile;
       $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an ".$consultation."  appointment after some time with ". $appointment->doctor->name." on " .date('d-m-Y',strtotime($appointment->slot->date)).'  '.$appointment->slot->start_time.".";
        
       Helper::sendSMS($data);
       }
       ///doctor sms
       if($appointment->doctor->mobile)
       {
        $consultation= $appointment->Appointmentdetail->consultation_type;
       $consultation=($consultation=1)?'Online Consultation ':'Offline Consultation ';
       $data['mobile'] = $appointment->doctor->mobile;
       $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an  ".$consultation."  appointment after some time with ". $appointment->Appointmentdetail->name ." on " .date('d-m-Y',strtotime($appointment->slot->date)).'  '.$appointment->slot->start_time.".";
       Helper::sendSMS($data);
     }
   }
}
