<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use DB;
use Carbon\Carbon;
use Kreait\Firebase;
use Kreait\Firebase\Factory;
use Kreait\Firebase\ServiceAccount;
use App\User;
use App\Model\Appointment;
use App\Doctor;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Support\Collection;

class AppointmentCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Appointment:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'firebug description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
       
       
        date_default_timezone_set('Asia/Kolkata');
        $endTime = date("H:i:s",strtotime('1 minutes'));
        $today = Carbon::today()->toDateString();
        $test1='19:25:00';
        $test2='19:37:00';
        $data= DB::table('appointments')
        ->join('appointment_details','appointment_details.appointment_id','appointments.id')
        ->join('slots', 'appointments.slot_id', '=', 'slots.id')
        ->whereDate('slots.date', '=',$today)
        ->whereTime('start_time', '>=',date("H:i:s"))
         //->whereTime('start_time', '>=',$test1)
        ->whereTime('start_time', '<',$endTime)
        //->whereTime('start_time', '>=',$test2)
        ->where('appointments.status','!=',4)
        ->where('appointments.status','!=',2)
        ->where('appointments.status','=',1)
        ->where('appointment_details.consultation_type','=',1)
        ->where('slots.status','=',1)
        ->get();
        
        $message=[];
        foreach ($data as $key => $value) {
            //update call status
            $updateststus=Doctor::find($value->doctor_id);
            $updateststus->call_status=0;
            $updateststus->save();

            $user=User::find($value->user_id);
            $doctor=Doctor::find($value->doctor_id);
            if( $user->firebase_id!=''){
            $message=array('to'=>$user->firebase_id,'data'=>array('body'=>"Appointment :$value->start_time - $value->end_time",'calltype'=>$value->consultation_type,'title'=>'Elixir Appointment','user'=>$user,'doctor'=>$doctor,'priority'=>"high"));
            $this->push_notification_android($message);
             $data =Appointment::with('Appointmentdetail','doctor','slot')->where('appointment_no',$value->appointment_no)->first();
              $this->send_user_appointment_sms($data);
            }
            sleep(5);
            if( $doctor->firebase_id!=''){
            $message=array('to'=>$doctor->firebase_id,'data'=>array('body'=>"Appointment : $value->start_time - $value->end_time",'calltype'=>$value->consultation_type,'title'=>'Elixir Appointment','user'=>$user,'doctor'=>$doctor,'priority'=>"high"));
            $this->push_notification_android($message);  
          }
            
            
             
           
        }
   //$message=array('to'=>"c_biYKudvrU:APA91bHfEv7oYOc9iqye3Twv55pXhPmIPnsgVEPfD4hUwkw08ahDjQP2_HPgzai5XTreHJ-nCTLBEfpUOSlrjKF0SXsTom0MDeb80Th_G7tGckB2N2TxvQRi68hjLV9GFN_6sHo1ej9x",'notification'=>array('body'=>"Appointment :zz",'title'=>'Elixer'));
   //$message=array('to'=>"c_biYKudvrU:APA91bHfEv7oYOc9iqye3Twv55pXhPmIPnsgVEPfD4hUwkw08ahDjQP2_HPgzai5XTreHJ-nCTLBEfpUOSlrjKF0SXsTom0MDeb80Th_G7tGckB2N2TxvQRi68hjLV9GFN_6sHo1ej9x",'notification'=>array('body'=>'Call to script1','title'=>'cron job')); 
       // $this->push_notification_android($message);

        if(count($message))
        {
        $reference='Cron Job notification';
        $data=array('name'=>'satya');
		$serviceAccount = ServiceAccount::fromJsonFile(base_path().'/abhisekfirebug.json');
        $firebase = (new Factory)
        ->withServiceAccount($serviceAccount)
        ->withDatabaseUri('https://elixer-80e95.firebaseio.com/')
        ->create();
        $database = $firebase->getDatabase();
        $newPost = $database
        ->getReference($reference)
        ->push($message);
        }
         
    }

    public function push_notification_android($message){

        //API URL of FCM
            $url = 'https://fcm.googleapis.com/fcm/send';

            /*api_key available in:
            Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key*/    $api_key = 'AIzaSyDz9mR-VuPMsVGd4YzMW9MY-CAHNRjq4VA';
                        
            

            //header includes Content type and api key
            $headers = array(
                'Content-Type:application/json',
                'Authorization:key='.$api_key
            );
                        
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
            $result = curl_exec($ch);
            print_r($result );
            if ($result === FALSE) {
                die('FCM Send Error: ' . curl_error($ch));
            }
            curl_close($ch);
            return $result;
    }

    public function send_user_appointment_sms($appointment){
        
        ///user sms
       if($appointment->Appointmentdetail->mobile)
       {
       $data['mobile'] = $appointment->Appointmentdetail->mobile;
       $data['msgtxt'] = "Hello ". $appointment->Appointmentdetail->name ." you have an appointment after some time with ". $appointment->doctor->name." on " .$appointment->slot->date.''.$appointment->slot->start_time.".";
        
       Helper::sendSMS($data);
       }
       ///doctor sms
       if($appointment->doctor->mobile)
       {
       $data['mobile'] = $appointment->doctor->mobile;
       $data['msgtxt'] = "Hello ". $appointment->doctor->name. " you have an appointment after some time with ". $appointment->Appointmentdetail->name ." on " .$appointment->slot->date.''.$appointment->slot->start_time.".";
       Helper::sendSMS($data);
     }
   }
}
