<!-- resources/views/admin/user/index.blade.php -->
<?php $request = app('Illuminate\Http\Request'); ?>

<?php $__env->startSection('content'); ?>
<div class="main_block">
  <section class="products_Section">
    <div class="row">
       <div class="col-md-12 col-xs-12 col-lg-12 col-sm-12">
         <div class="main_heading_block pull-right">
            <a href="<?php echo e(url('/upload-user')); ?>" class="btn btn-success">Bulk Upload</a>    
            <a href="<?php echo e(route('user.create')); ?>" class="btn btn-success pull-right"><?php echo app('translator')->getFromJson('global.new_news'); ?></a> 
         </div> 
       </div>
    </div>
  </section>
  <section class="section1">
      <div class="row">
         <div class="col-md-12 col-xs-12 col-lg-12 col-sm-12">
           <div class="box1">
              <div class="listing_product">
                 <h3><span>User <?php echo app('translator')->getFromJson('global.app_list'); ?></span> <!-- <sub> admin listing... </sub> --></h3>
              </div>
              <div class="listin_table_block">
              <table class="table table-bordered table-striped <?php echo e(count($data) > 0 ? 'datatable' : ''); ?> dt-select">
                <thead>
                    <tr>
                        <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Email</th>
                        <th>Amount</th> <!-- New heading for Amount -->
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($data) > 0): ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-entry-id="<?php echo e($val->id); ?>">
                                <td></td>
                                <td><?php echo e($val->name ?? ''); ?></td>
                                <td><?php echo e($val->mobile ?? ''); ?></td>
                                <td><?php echo e($val->email ?? ''); ?></td>
                                <td><?php echo e($val->walletBalance->amount ?? '0'); ?></td> <!-- Display amount from walletBalance -->
                                <td><?php if($val->online_status == 1): ?> Online <?php else: ?> Offline <?php endif; ?></td>
                                <td>
                                    <a href="<?php echo e(route('user.edit', [$val->id])); ?>" class="btn btn-xs btn-info"><?php echo app('translator')->getFromJson('global.app_edit'); ?></a>
                                    <?php echo Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("global.app_are_you_sure")."');",
                                        'route' => ['user.destroy', $val->id])); ?>

                                    <?php echo Form::submit(trans('global.app_delete'), array('class' => 'btn btn-xs btn-danger')); ?>

                                    <?php echo Form::close(); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7"><?php echo app('translator')->getFromJson('global.app_no_entries_in_table'); ?></td> <!-- Updated colspan to 7 -->
                        </tr>
                    <?php endif; ?>
                </tbody>
              </table>
              </div>
           </div>
         </div>
      </div>
   </section> 
</div>
<?php $__env->stopSection(); ?>                                
<?php $__env->startSection('javascript'); ?> 
    <script>
         window.route_mass_crud_entries_destroy = '<?php echo e(route('user.mass_destroy')); ?>';
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/synchash1/public_html/design.synchash.in/resources/views/admin/user/index.blade.php ENDPATH**/ ?>