

<?php $__env->startSection('content'); ?>
<h3 class="page-title">Edit Lab Report</h3>

<?php echo Form::model($report, ['method' => 'PUT', 'route' => ['wallet.labreportUpdate', $report['id']], 'enctype' => 'multipart/form-data']); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <?php echo app('translator')->getFromJson('global.app_edit'); ?>
    </div>

    <div class="panel-body">
        <div class="row">
            <div class="col-xs-12 form-group">
                <?php echo Form::label('name', 'Name', ['class' => 'control-label']); ?>

                <?php echo Form::text('name', $report['name'], ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('user', 'User', ['class' => 'control-label']); ?>

                    
                    <?php echo Form::select('user_id', $user, old('user_id'), ['class' => 'form-control select2']); ?>

                     
                </div>
            </div>

        <div class="row">
            <div class="col-xs-12 form-group">
                <?php echo Form::label('reportType', 'Doctor Report Type', ['class' => 'control-label']); ?>

                <?php echo Form::select('reportType', [
                    'Prescription' => 'Prescription',
                    'Lab Report' => 'Lab Report'
                ], $report['reportType'], ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="row">
            <div class="col-xs-12 form-group">
                <label>Replace Uploaded Report (optional)</label>
                <?php echo Form::file('reportUpload', ['class' => 'form-control']); ?>

                <?php if($report['reportUpload']): ?>
                    <p>Current: 
                        <a href="<?php echo e(asset('storage/' . $report['reportUpload'])); ?>" target="_blank">View File</a>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php echo Form::submit(trans('global.app_update'), ['class' => 'btn btn-primary']); ?>

<a href="<?php echo e(url('labreport')); ?>" class="btn btn-danger"><?php echo app('translator')->getFromJson('global.app_cancel'); ?></a>

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/synchash1/public_html/design.synchash.in/resources/views/admin/wallet/labReportEdit.blade.php ENDPATH**/ ?>