<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <h3 class="page-title">Call Log</h3>
     

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped <?php echo e(count($data) > 0 ? 'datatable' : ''); ?> dt-select">
                <thead>
                    <tr>
                       <th style="text-align:center;"><input type="checkbox" id="select-all"/></th>
                        <th>User </th>
                        <th>Doctor</th>
                        <th>Call Start</th>
                        <th>Call End</th>
                        <th>Call Time</th>
                        <th>Amount</th>
                        <th>Date</th>
                    </tr>
                </thead>
                
                <tbody>
                    <?php if(count($data) > 0): ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                        $diff_in_minutes=0;

                        if($value->call_at!=NULL && $value->call_end!=NULL)
                        {
                            
                         $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $value->call_at);
                         $from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $value->call_end);
                         $diff_in_minutes = $to->diffInMinutes($from);
                        }
                        ?>
                            <tr data-entry-id="<?php echo e($value->id); ?>">
                                <td></td>
                                <td><?php echo e($value->user->name ?? ''); ?></td>
                                <td><?php echo e($value->doctor->name ?? ''); ?></td>
                                 
                                <td><?php if($value->call_at!='' && $value->call_at!='0000-00-00 00:00:00'): ?> <?php echo e(date('d-m-Y h:s:i',strtotime($value->call_at)) ?? ''); ?><?php endif; ?></td> 
                               
                                <td><?php if($value->call_end!='' && $value->call_end!='0000-00-00 00:00:00'): ?> <?php echo e(date('d-m-Y h:s:i',strtotime($value->call_end)) ?? ''); ?><?php endif; ?></td> 
                                <td><?php echo e($diff_in_minutes ?? ''); ?></td>
                                <td><?php echo e($value->amount ?? ''); ?></td>
                                 
                                <td><?php if($value->created_at!='' && $value->created_at!='0000-00-00 00:00:00'): ?> <?php echo e(date('d-m-Y',strtotime($value->created_at)) ?? ''); ?><?php endif; ?></td> 
                                 
                                 
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="9"><?php echo app('translator')->getFromJson('global.app_no_entries_in_table'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/synchash1/public_html/design.synchash.in/resources/views/admin/call-log/index.blade.php ENDPATH**/ ?>