<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'AdminloginController@Loginform');

 

Route::get('adminlogin', 'AdminloginController@Loginform');
Route::post('adminlogin', 'AdminloginController@Login');
Route::get('logout', 'AdminloginController@logout');
Route::get('test', 'AdminloginController@testform');

Route::get('labReport', 'Admin\UserWalletController@labreport');
Route::get('wallet/lab-report/create', 'Admin\UserWalletController@labReportCreate')->name('wallet.labReportCreate');
Route::post('labreport/store', 'Admin\UserWalletController@labreportStore')->name('labreport.store');
Route::get('labreport/{id}/edit', 'Admin\UserWalletController@labreportEdit')->name('wallet.labreportEdit');
Route::put('labreport/{id}', 'Admin\UserWalletController@labreportUpdate')->name('wallet.labreportUpdate');
Route::delete('labreport/{id}', 'Admin\UserWalletController@labreportDelete')->name('wallet.labreportDelete');
Route::get('labreport/show/{id}','Admin\UserWalletController@labreportShow')->name('wallet.labreportShow'); 

Route::get('preScription', 'Admin\UserWalletController@prescription');
Route::get('wallet/prescription/create', 'Admin\UserWalletController@prescriptionCreate')->name('wallet.prescriptionCreate');
Route::post('prescription/store', 'Admin\UserWalletController@prescriptionStore')->name('labreport.store');
Route::get('prescription/{id}/edit', 'Admin\UserWalletController@prescriptionEdit')->name('wallet.prescriptionEdit');
Route::put('prescription/{id}', 'Admin\UserWalletController@prescriptionUpdate')->name('wallet.prescriptionUpdate');
Route::delete('prescription/{id}', 'Admin\UserWalletController@prescriptionDelete')->name('wallet.prescriptionDelete');
Route::get('prescription/show/{id}','Admin\UserWalletController@prescriptionShow')->name('wallet.prescriptionShow');
    
Route::group(['middleware' => ['admin']], function () {
    
    Route::get('dashboard', 'AdminloginController@dashboard');
    Route::get('appointment', 'Admin\AppointmentController@index');
    Route::get('call-record', 'Admin\CallrecordController@index');

    Route::post('doctor_mass_destroy', ['uses' => 'Admin\DoctorController@massDestroy', 'as' => 'doctor.mass_destroy']);
    Route::resource('doctor', 'Admin\DoctorController');
    Route::get('peripheraldoctor', 'Admin\DoctorController@Peripheraldoctor');
    Route::post('user_mass_destroy', ['uses' => 'Admin\UserController@massDestroy', 'as' => 'user.mass_destroy']);
    Route::resource('user', 'Admin\UserController');
    Route::get('upload-user', 'Admin\UserController@uploaduser');
    Route::post('upload-user', 'Admin\UserController@import');

    Route::post('payment_mass_destroy', ['uses' => 'Admin\PaymentController@massDestroy', 'as' => 'payment.mass_destroy']);
    Route::resource('payment', 'Admin\PaymentController');


    Route::post('wallet_mass_destroy', ['uses' => 'Admin\UserWalletController@massDestroy', 'as' => 'wallet.mass_destroy']);
    Route::resource('wallet', 'Admin\UserWalletController');

    Route::post('assisdoctor_mass_destroy', ['uses' => 'Admin\AssistantdoctorController@massDestroy', 'as' => 'assisdoctor.mass_destroy']);
    Route::resource('assisdoctor', 'Admin\AssistantdoctorController');
    
});
Route::get('mailcheck',function(){
    
    $user = array();
    Mail::send('email.test', $user, function($message) use ($user) {
        $message->to("satyendra.singh43@gmail.com");
        $message->subject('Mailgun Testing');
    });
    dd('Mail Send Successfully');
});



 
