@extends('layouts.masterlayout')
@section('content')
<section class="mydashboard m-5">
    <div class="container">
        <div class="row">
            <div class="col-md-3 col-lg-3 col-sm-3 col-xl-3 col-12">Left Content</div>
            <div class="col-12 col-lg-9 col-sm-9 col-xl-9 col-md-9">
                <ul class="nav nav-tabs" id="mydashboardTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="wishlist-tab" data-toggle="tab" href="#wishlist" role="tab" aria-controls="wishlist" aria-selected="true">Wishlist</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="questionanswer-tab" data-toggle="tab" href="#questionanswer" role="tab" aria-controls="questionanswer" aria-selected="false">Q&A</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="reviews-tab" data-toggle="tab" href="#reviews" role="tab" aria-controls="reviews" aria-selected="false">Reviews</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Profile</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="wishlist" role="tabpanel" aria-labelledby="wishlist-tab">

                        <!--Single College Structure Start-->
                         
                        @if(!empty($college))
                        @foreach($college as $key=>$value)
                        <div class="col-md-6 col-xl-6 col-lg-6 col-sm-6 col-12" >
                            <div class="main_cat_block">
                                <div class="category_right_block">
                                    <a href='{{url("university-college/$value->slugs")}}'><img src='{{url("$value->image")}}' alt="{{$value->ttile or ''}}" /></a>
                                    <div class="courses_placement">
                                        <ul>
                                            <li><a href='{{url("university-college/$value->slugs")}}#courses'>Courses</a></li>
                                            <li><a href='{{url("university-college/$value->slugs")}}#contactUs'>Contact</a></li>
                                            <li><a href='{{url("university-college/$value->slugs")}}#news'>News</a></li>
                                            <li><a href='{{url("university-college/$value->slugs")}}'>+7 more</a></li></li>
                                        </ul>
                                    </div>
                                    <div class="star_top">4.5</div>        
                                </div>
                                <div class="college_name">
                                    <a href='{{url("university-college/$value->slugs")}}'><p class="heading">{{$value->college or ''}}</p></a>
                                    <p class="established_year">Established in {{$value->college_estd   or ''}}  |  Approved by: {{affiliation($value->id)}}   | {{$collagesector[$value->college_type] or ''}} | {{$collagetype[$value->type] or ''}}</p>
                                    <ul>
                                        @php $coursedata=college_course($value->id);
                                        $coursefee=@collegecoursefee($value->id,$coursedata->specialization_id);
                                        @endphp
                                        <li>Courses <br /> <span>{{$coursedata->course_name or ''}}</span></li>
                                        <li>Fee <br /> <span>{{$coursefee->fee or ''}} <?php if (isset($coursefee->fee)) echo 'INR'; ?></span></li>
                                        <li>Duration <br /> <span>{{$coursedata->duration or ''}} {{@config('constants.DURATIONTYPE')[$coursedata->duration_type]}}</span></li>
                                    </ul>
                                </div>
                                <div class="download_brocture">
                                    <ul>
                                        <li>
                                            @if($value->brochure)
                                            <a href='{{url("download/$value->id")}}'>
                                                @else
                                                <a href='#'>
                                                    @endif
                                                    Download Brochur</a>
                                        </li>
                                        @if(Auth::guard('student')->user())
                                        <li><a onclick="ApplyNOW(`{{$value->id}}`);" href="javascript:void()">Apply now</a></li>
                                        @else
                                        <li><a  href="javascript:void()" data-toggle="modal" data-target="#myModal" >Apply now</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @endif
                        <!--Single College Structure End-->
                    </div>
                    <div class="tab-pane fade" id="questionanswer" role="tabpanel" aria-labelledby="questionanswer-tab">Question and Answer</div>
                    <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">Reviews</div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">Profile</div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
