@extends('layouts.app')

@section('content')
<h3 class="page-title">Edit Lab Report</h3>

{!! Form::model($report, ['method' => 'PUT', 'route' => ['wallet.prescriptionUpdate', $report['id']], 'enctype' => 'multipart/form-data']) !!}

<div class="panel panel-default">
    <div class="panel-heading">
        @lang('global.app_edit')
    </div>

    <div class="panel-body">
        <div class="row">
            <div class="col-xs-12 form-group">
                {!! Form::label('name', 'Name', ['class' => 'control-label']) !!}
                {!! Form::text('name', $report['name'], ['class' => 'form-control']) !!}
            </div>
        </div>

        <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('user', 'User', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('user_id', $user, old('user_id'), ['class' => 'form-control select2']) !!}
                     
                </div>
            </div>

        <div class="row">
            <div class="col-xs-12 form-group">
                {!! Form::label('reportType', 'Doctor Report Type', ['class' => 'control-label']) !!}
                {!! Form::select('reportType', [
                    'Prescription' => 'Prescription',
                    'Lab Report' => 'Lab Report'
                ], $report['reportType'], ['class' => 'form-control']) !!}
            </div>
        </div>

        <div class="row">
            <div class="col-xs-12 form-group">
                <label>Replace Uploaded Report (optional)</label>
                {!! Form::file('reportUpload', ['class' => 'form-control']) !!}
                @if ($report['reportUpload'])
                    <p>Current: 
                        <a href="{{ asset('storage/' . $report['reportUpload']) }}" target="_blank">View File</a>
                    </p>
                @endif
            </div>
        </div>
    </div>
</div>

{!! Form::submit(trans('global.app_update'), ['class' => 'btn btn-primary']) !!}
<a href="{{ url('labreport') }}" class="btn btn-danger">@lang('global.app_cancel')</a>

{!! Form::close() !!}
@endsection