@extends('layouts.app')

@section('content')
    <h3 class="page-title">Add Prescription Report</h3>

    {!! Form::open(['method' => 'POST', 'route' => ['labreport.store'], 'enctype' => 'multipart/form-data']) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('global.app_create')
        </div>
        
       
        <div class="panel-body">
            
              <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('type', 'Doctor ', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('doctor_id', $doctor, old('doctor_id'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>


            {{-- Name --}}
           <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('user', 'User', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('user_id', $user, old('user_id'), ['class' => 'form-control select2']) !!}
                     
                </div>
            </div>

           

            {{-- Report Type --}}
            <div class="row">
    <div class="col-xs-12 form-group">
        {!! Form::label('reportType', 'Doctor Report Type', ['class' => 'control-label']) !!}
        {!! Form::select('reportType', [
            'Prescription' => 'Prescription',
        ], old('reportType'), ['class' => 'form-control']) !!}
    </div>
</div>

            {{-- Report Upload --}}
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('reportUpload', 'Upload Report (PDF/Image)', ['class' => 'control-label']) !!}
                    {!! Form::file('reportUpload', ['class' => 'form-control', 'required']) !!}
                </div>
            </div>
        </div>
    </div>

    {!! Form::submit(trans('global.app_save'), ['class' => 'btn btn-success']) !!}
    &nbsp;&nbsp;
    <a href="{{ url('labreport') }}" class="btn btn-danger">@lang('global.app_cancel')</a>
    {!! Form::close() !!}
@endsection