@extends('layouts.app')

@section('content')
<h3 class="page-title">View Lab Report</h3>

<div class="panel panel-default">
    <div class="panel-heading">
        Lab Report Details
    </div>

    <div class="panel-body">

        {{-- Name --}}
        <div class="row">
            <div class="col-xs-12 form-group">
                <strong>Name:</strong>
                <p>{{ $report['name'] }}</p>
            </div>
        </div>

        {{-- User --}}
        <div class="row">
            <div class="col-xs-12 form-group">
                <strong>User:</strong>
                <p>{{ $user[$report['user_id']] ?? 'N/A' }}</p>
            </div>
        </div>

        {{-- Report Type --}}
        <div class="row">
            <div class="col-xs-12 form-group">
                <strong>Doctor Report Type:</strong>
                <p>{{ $report['reportType'] }}</p>
            </div>
        </div>

        {{-- Uploaded Report --}}
        <div class="row">
            <div class="col-xs-12 form-group">
                <strong>Uploaded Report:</strong><br>
                @if ($report['reportUpload'])
                    <a href="{{ asset('storage/' . $report['reportUpload']) }}" target="_blank">View File</a>
                @else
                    <p>No file uploaded</p>
                @endif
            </div>
        </div>

        {{-- Back button --}}
        <a href="{{ url('labReport') }}" class="btn btn-default">Back</a>

    </div>
</div>
@endsection