@extends('layouts.app')

@section('content')
    <h3 class="page-title">Upload User</h3>

@if ($message = Session::get('success'))
<div class="alert alert-success alert-block">
	<button type="button" class="close" data-dismiss="alert">×</button>	
        <strong>{{ $message }}</strong>
</div>
@endif
@if ($message = Session::get('error'))
<div class="alert alert-danger alert-block">
	<button type="button" class="close" data-dismiss="alert">×</button>	
        <strong>{{ $message }}</strong>
</div>
@endif

    {!! Form::open(['method' => 'POST', 'files' => true,'url' => 'upload-user']) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
        Upload
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('name', 'File*', ['class' => 'control-label']) !!}
                    <input type="file" name="uploadfile"/>
                </div>
            </div>
        </div>
    </div>

    {!! Form::submit(trans('global.app_save'), ['class' => 'btn btn-success']) !!}
    {!! Form::button(trans('global.app_sample'), ['class' => 'btn btn-success','id'=>'sample']) !!}
    {!! Form::close() !!}
    <script type="text/javascript" src="//unpkg.com/xlsx/dist/xlsx.full.min.js"></script>

    <script>
    $('#sample').on('click',function(){

     
 
 
        var createXLSLFormatObj = [];
 
        /* XLS Head Columns */
        var xlsHeader = ["SN", "ID",
        "Mobile",
        "Email",
        "Name of the Patient",
        "AGE",
        "D O B",
        "GEN",
        "Adress - Location",
        "First Visit",
        "DIAGNOSIS",
        "Last Presription"
        ];
 
        /* XLS Rows Data */
        var xlsRows = [{
                "SN": "XXX",
                "ID": "XXX",
                "Mobile": "XXX",
                "Email": "XXX",
                "Name of the Patient": "XXX",
                "AGE": "XXX",
                "D O B": "XXX",
                "GEN": "2",
                "Address - Location": "XXX",
                "First Visit": "XXX",
                "DIAGNOSIS": "XXX",
                "Last Presription": "XXX",
                
            } 
             
        ];
 
 
        createXLSLFormatObj.push(xlsHeader);
        $.each(xlsRows, function(index, value) {
            var innerRowData = [];
            $("tbody").append('<tr><td>' + value.EmployeeID + '</td><td>' + value.FullName + '</td></tr>');
            $.each(value, function(ind, val) {
 
                innerRowData.push(val);
            });
            createXLSLFormatObj.push(innerRowData);
        });
 
 
        /* File Name */
        var filename = "sample.xlsx";
 
        /* Sheet Name */
        var ws_name = "FreakySheet";
 
        if (typeof console !== 'undefined') console.log(new Date());
        var wb = XLSX.utils.book_new(),
            ws = XLSX.utils.aoa_to_sheet(createXLSLFormatObj);
 
        /* Add worksheet to workbook */
        XLSX.utils.book_append_sheet(wb, ws, ws_name);
 
        /* Write workbook and Download */
        if (typeof console !== 'undefined') console.log(new Date());
        XLSX.writeFile(wb, filename);
        if (typeof console !== 'undefined') console.log(new Date());
 
    });
    </script>
@stop

