@extends('layouts.app')

@section('content')
    <h3 class="page-title">Doctor</h3>
    {!! Form::open(['method' => 'POST', 'route' => ['doctor.store'],'enctype'=>"multipart/form-data"]) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('global.app_create')
        </div>
        
        <div class="panel-body">

        <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('type', 'Doctor Type', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('type', config('constants.doctortype'), old('blogtag'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>


            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('online_status', 'Online Status', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('online_status', config('constants.online_status'), old('blogtag'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>
             
             
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('doctor_elixir_id', ' Doctor Elixir Id*', ['class' => 'control-label']) !!}
                    {!! Form::text('doctor_elixir_id', old('doctor_elixir_id'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                    
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('name', ' Name*', ['class' => 'control-label']) !!}
                    {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                     
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('mobile', ' Mobile*', ['class' => 'control-label']) !!}
                    {!! Form::text('mobile', old('mobile'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('email', ' Email*', ['class' => 'control-label']) !!}
                    {!! Form::text('email', old('email'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                     
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('profile', ' Profile Picture', ['class' => 'control-label']) !!}
                    <input type="file" name="profile" >
                     
                </div>
            </div>

           

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('dob', ' Dob', ['class' => 'control-label']) !!}
                    {!! Form::text('dob', old('dob'), ['class' => 'form-control datepicker', 'placeholder' => '']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('gender', 'Gender', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('gender', config('constants.gender'), old('blogtag'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('specialization', ' Specialization', ['class' => 'control-label']) !!}
                    {!! Form::text('specialization', old('specialization'), ['class' => 'form-control', 'placeholder' => '']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('adwards_and_certificates', ' Adwards & Certificates', ['class' => 'control-label']) !!}
                    {!! Form::text('adwards_and_certificates', old('adwards_and_certificates'), ['class' => 'form-control', 'placeholder' => '']) !!}
                     
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('organisation', ' Organisation', ['class' => 'control-label']) !!}
                    {!! Form::text('organisation', old('organisation'), ['class' => 'form-control', 'placeholder' => '']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('registration', ' Registration', ['class' => 'control-label']) !!}
                    {!! Form::text('registration', old('registration'), ['class' => 'form-control', 'placeholder' => '']) !!}
                     
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('address', ' Address', ['class' => 'control-label']) !!}
                    {!! Form::text('address', old('address'), ['class' => 'form-control', 'placeholder' => '']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('education', ' Education', ['class' => 'control-label']) !!}
                    {!! Form::text('education', old('education'), ['class' => 'form-control', 'placeholder' => '']) !!}
                     
                </div>
            </div>
           
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('about', 'About', ['class' => 'control-label']) !!}
                    {!! Form::textarea('about', old('about'), ['class' => 'form-control editor1' ]) !!}
                     
                </div>
            </div>
            
             
             
             
            
        </div>
    </div>

    {!! Form::submit(trans('global.app_save'), ['class' => 'btn btn-success']) !!}
    &nbsp;&nbsp; &nbsp;
    <a href="{{url('doctor')}}">{!! Form::button(trans('global.app_cancel'), ['class' => 'btn btn-danger']) !!}</a>
    {!! Form::close() !!}
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.3.0/css/datepicker.css" rel="stylesheet" type="text/css" />
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.3.0/js/bootstrap-datepicker.js"></script>
    <script>
     
    
   $(function(){
    $( ".datepicker" ).datepicker({
        dateFormat: 'yy-mm-dd',
        changeMonth: true,
        changeYear: true,
        autoclose: true,
    })
});
 
    </script>
  
    
@stop

