@inject('request', 'Illuminate\Http\Request')
@extends('layouts.app')

@section('content')
    <h3 class="page-title">Call Log</h3>
     

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('global.app_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($data) > 0 ? 'datatable' : '' }} dt-select">
                <thead>
                    <tr>
                       <th style="text-align:center;"><input type="checkbox" id="select-all"/></th>
                        <th>User </th>
                        <th>Doctor</th>
                        <th>Call Start</th>
                        <th>Call End</th>
                        <th>Call Time</th>
                        <th>Amount</th>
                        <th>Date</th>
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($data) > 0)
                        @foreach ($data as $value)
                        <?php 
                        $diff_in_minutes=0;

                        if($value->call_at!=NULL && $value->call_end!=NULL)
                        {
                            
                         $to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $value->call_at);
                         $from = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', $value->call_end);
                         $diff_in_minutes = $to->diffInMinutes($from);
                        }
                        ?>
                            <tr data-entry-id="{{ $value->id }}">
                                <td></td>
                                <td>{{$value->user->name ?? ''}}</td>
                                <td>{{$value->doctor->name ?? ''}}</td>
                                 
                                <td>@if($value->call_at!='' && $value->call_at!='0000-00-00 00:00:00') {{date('d-m-Y h:s:i',strtotime($value->call_at)) ?? ''}}@endif</td> 
                               
                                <td>@if($value->call_end!='' && $value->call_end!='0000-00-00 00:00:00') {{date('d-m-Y h:s:i',strtotime($value->call_end)) ?? ''}}@endif</td> 
                                <td>{{$diff_in_minutes ?? ''}}</td>
                                <td>{{$value->amount ?? ''}}</td>
                                 
                                <td>@if($value->created_at!='' && $value->created_at!='0000-00-00 00:00:00') {{date('d-m-Y',strtotime($value->created_at)) ?? ''}}@endif</td> 
                                 
                                 
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="9">@lang('global.app_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

 