@inject('request', 'Illuminate\Http\Request')
@extends('layouts.app')
@section('content')
<div class="main_block">
  <section class="products_Section">
    <div class="row">
       <div class="col-md-12 col-xs-12 col-lg-12 col-sm-12">
         <div class="main_heading_block">
          <h2> <a href="{{ route('assisdoctor.create') }}" class="btn btn-success pull-right">@lang('global.new_news')</a></h2>
         </div> 
       </div>
    </div>
@if ($message = Session::get('error'))
<div class="alert alert-danger alert-block">
	<button type="button" class="close" data-dismiss="alert">×</button>	
        <strong>{{ $message }}</strong>
</div>
@endif
  </section>
  <section class="section1">
      <div class="row">
         <div class="col-md-12 col-xs-12 col-lg-12 col-sm-12">
           <div class="box1">
              <div class="listing_product">
                 <h3><span>  Assistant Doctor @lang('global.app_list')</span> <!-- <sub> admin listing... </sub> --></h3>
              </div>
              <div class="listin_table_block">
              <table class="table table-bordered table-striped {{ count($data) > 0 ? 'datatable' : '' }} dt-select">
                <thead>
                    <tr>
                        <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        <th>Doctor</th>
                        <th>Ass. Doctor</th>
                        
                        <th>Action</th>

                    </tr>
                </thead>
                
                <tbody>
                    @if (count($data) > 0)
                        @foreach ($data as $val)
                            <tr data-entry-id="{{ $val->id }}">
                                <td></td>
                                <td>{{$val->name ?? '' }}</td>
                                <td>{{ @$assistancedoc[$val->doctor_assistance_id] ?? '' }}</td>
                                 
                                <td>
                                    <a href="{{ route('assisdoctor.edit',[$val->id]) }}" class="btn btn-xs btn-info">@lang('global.app_edit')</a>
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("global.app_are_you_sure")."');",
                                        'route' => ['assisdoctor.destroy', $val->id])) !!}
                                    {!! Form::submit(trans('global.app_delete'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                     
                                </td>

                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="4">@lang('global.app_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
              </div>
           </div>
         </div>
      </div>
   </section> 
</div>
@stop                                
@section('javascript') 
    <script>
         window.route_mass_crud_entries_destroy = '{{ route('assisdoctor.mass_destroy') }}';
    </script>
@endsection
