@inject('request', 'Illuminate\Http\Request')
@extends('layouts.app')

@section('content')
    <h3 class="page-title">Appointment</h3>
     

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('global.app_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($data) > 0 ? 'datatable' : '' }} dt-select">
                <thead>
                    <tr>
                        <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        <th>Appointment</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Email</th>
                        <th>Doctor</th>
                        <th>Status</th>
                        <th>Appointment Time</th>
                        <th>Appointment Date</th>

                    </tr>
                </thead>
                
                <tbody>
                    @if (count($data) > 0)
                        @foreach ($data as $category)
                            <tr data-entry-id="{{ $category->id }}">
                                <td></td>

                                <td>{{$category->appointment_no ?? ''}} </td>
                                <td> {{ $category->Appointmentdetail->name ?? '' }}</td>
                                <td> {{ $category->Appointmentdetail->mobile ?? '' }}</ td>
                                <td> {{ $category->Appointmentdetail->email ?? ''}}</td>
                                <td>{{$category->doctor->name ??  ''}} </td>
                                <td> @if($category->status==0)
                                         
                                      @elseif($category->status==1)
                                      Accept
                                      @elseif($category->status==3)
                                      Completed
                                      @elseif($category->status==4)
                                      Cancelled
                                      @else
                                      Rescheduled
                                      @endif
                                
                                  </td>
                                  <td>{{$category->slot->start_time ??  ''}}   </td>
                                <td>@if($category->date!='' && $category->date!='0000-00-00 00:00:00') {{date('d-m-Y',strtotime($category->date)) ?? ''}}@endif</td>
                                 
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="9">@lang('global.app_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

 