@extends('layouts.app')

@section('content')
    <h3 class="page-title">@lang('global.blog.title')</h3>
    {!! Form::open(['method' => 'POST', 'route' => ['admin.blog.store'],'enctype'=>"multipart/form-data"]) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('global.app_create')
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('blog', ' Title*', ['class' => 'control-label']) !!}
                    {!! Form::text('blog_title', old('blog_title'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('blog_title'))
                        <p class="help-block">
                            {{ $errors->first('blog_title') }}
                        </p>
                    @endif
                </div>
            </div>
            
           
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('description', 'Description', ['class' => 'control-label']) !!}
                    {!! Form::textarea('description', old('description'), ['class' => 'form-control editor1' ]) !!}
                    <p class="help-block"></p>
                    @if($errors->has('description'))
                        <p class="help-block">
                            {{ $errors->first('description') }}
                        </p>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('blogtag', 'Select Tag', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('blogtag', config('constants.NEWSTAG'), old('blogtag'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('Image', 'Blog thumb image', ['class' => 'control-label','required' => '']) !!}
                     

                    {!! Form::file('image', old('image'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('image'))
                        <p class="help-block">
                            {{ $errors->first('image') }}
                        </p>
                    @endif
                </div>
            </div>

            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('Image', 'Blog full image', ['class' => 'control-label','required' => '']) !!}
                     

                    {!! Form::file('fullimage', old('fullimage'), ['class' => 'form-control', 'placeholder' => '', 'required' => '']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('date', 'Date', ['class' => 'control-label']) !!}
                    {!! Form::text('date', old('date'), ['class' => 'form-control','id'=>'datepicker']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('author', 'Author', ['class' => 'control-label']) !!}
                    {!! Form::text('author', old('author'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>
            
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('metatitle', 'Meta title', ['class' => 'control-label']) !!}
                    {!! Form::text('metatitle', old('metatitle'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>

             
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('metatag', 'Meta Tag', ['class' => 'control-label']) !!}
                    {!! Form::text('metatag', old('mmetatag'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('metadesc', 'Meta Description', ['class' => 'control-label']) !!}
                    {!! Form::textarea('metadesc', old('metadesc'), ['class' => 'form-control textarea']) !!}
                    
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('order', 'Short order', ['class' => 'control-label']) !!}
                    {!! Form::number('order', old('order'), ['class' => 'form-control', 'placeholder' => '', ]) !!}
                     
                </div>
            </div>
             
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('Status', 'Status', ['class' => 'control-label']) !!}
                    
                    {!! Form::select('status', config('constants.STATUS'), old('status'), ['class' => 'form-control']) !!}
                     
                </div>
            </div>
            
        </div>
    </div>

    {!! Form::submit(trans('global.app_save'), ['class' => 'btn btn-success']) !!}
    &nbsp;&nbsp; &nbsp;
    <a href="{{url('admin/blog')}}">{!! Form::button(trans('global.app_cancel'), ['class' => 'btn btn-danger']) !!}</a>
    {!! Form::close() !!}
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.3.0/css/datepicker.css" rel="stylesheet" type="text/css" />
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.3.0/js/bootstrap-datepicker.js"></script>
    <script>
     
    
   $(function(){
    $( "#datepicker" ).datepicker({
        dateFormat: 'yy-mm-dd',
        changeMonth: true,
        changeYear: true,
        autoclose: true,
    })
});
 
    </script>
  
    
@stop

