<?php

namespace App\Rules;

use App\Doctor;
use App\User;
use Illuminate\Contracts\Validation\Rule;

class UserExistsRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if(User::whereMobile($value)->exists() || Doctor::whereMobile($attribute)->exists()){
            return true;
        }
        return false;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return "User Doesn't exists.";
    }
}
