<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SlotResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'type_time' => $this->type_time,
            'start_time' => date('h:i',strtotime($this->start_time)), 
            'end_time' => date('h:i',strtotime($this->end_time)), 
            'status' => $this->status
        ];
    }
}
