<?php

namespace App\Http\Resources;

use App\Doctor;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\SlotResource;
use App\Model\Slot;
use App\Model\DoctorDetails;
use App\Model\UserWalletBalance;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use Carbon\Carbon;
class AppointmentResourceOne extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        
    	date_default_timezone_set('Asia/Kolkata');
         //dd(date("h:i:s"));
        
       $credit_wallet= UserWalletBalance::select('amount')->where('user_id',Auth::id())->where('payment_type','credit')->sum('amount');
       $debit_wallet= UserWalletBalance::select('amount')->where('user_id',Auth::id())->where('payment_type','debit')->sum('amount');
       $wallet=$credit_wallet-$debit_wallet;
        
       $img=DB::table('user_details')->select('profile')->where('user_id',Auth::id())->get();
         $today = Carbon::today()->toDateString();
        $slots= DB::table('appointments')
            ->join('slots', 'appointments.slot_id', '=', 'slots.id')
            ->join('appointment_details','appointment_details.appointment_id','appointments.id')
            ->where('appointments.user_id',Auth::id())
            ->where(function($q) use ($today) {
			      $q->whereDate('slots.date', '>=',$today)
			        ->whereTime('start_time', '>=',date("H:i:s"))
			        ->where('appointments.status','!=',4)
                     ->where('appointments.user_id',Auth::id())
                     ->where('appointments.status','!=',2);
			  })
            ->orwhere(function($qq) use ($today) {
            	   $qq->whereDate('slots.date', '>',$today)
                        
            	       ->where('appointments.status','!=',4)
                       ->where('appointments.user_id',Auth::id())
            	       ->where('appointments.status','!=',2);
            	   
            })
           
            
            ->orderby('slots.id','ASC')
            ->select('slots.*',
            	'appointments.appointment_no',
            	'appointment_details.consultation_type',
            	'appointment_details.consultation_type',
            	'appointment_details.appoinment_type',
            	'appointments.status' )

            ->first();
            // dd(date("h:i:s"));
        $solotmsg=array('slot'=>array('message'=>"Slots unavailable"));
        //dd($request);
        return [
            'id' => $this->id,
            'appointment_no' => $this->appointment_no,
            'profile' =>$img[0]->profile,
            'status' => $this->status,
           // 'slot' => new SlotResource(Slot::find($this->slot_id)),
            'slot' =>($slots)?$slots:$solotmsg ,
            'doctor' => new DoctorResource(Doctor::find($this->slot->doctor_id)),
            'total_price'=>DB::table('user_amount')->select('total_amount')->where('user_id',Auth::id())->sum('total_amount')+$wallet,
           // 'doctor_info' => DoctorDetails::whereDoctorId($this->slot->doctor_id)->get(),
            'doctor_rate' => DB::table('doctor_rates')->where('doctor_id',$this->slot->doctor_id)->get()
        ];
    }
}
