<?php

namespace App\Http\Resources;

use App\Doctor;
use App\Http\Resources\Doctor\DoctorResource;
use App\Http\Resources\SlotResource;
use App\Model\Slot;
use App\Model\DoctorDetails;
use Illuminate\Http\Resources\Json\JsonResource;

class AppointmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        
        return [
            'id' => $this->id,
            'appointment_no' => $this->appointment_no,
            'status' => $this->status,
            'slot' => new SlotResource(Slot::find($this->slot_id)),
            'doctor' => new DoctorResource(Doctor::find($this->slot->doctor_id)),
            'appointment_date'=>$this->date,
        ];
    }
}
