<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DoctorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'doctor_elixir_id' => 'required|unique:doctors,doctor_elixir_id',
            'mobile' => 'required|unique:doctors,mobile',
            'email' => 'required|unique:doctors,email',
            'name' => 'required',
            'dob' => 'required',
            'organisation' => 'required',
            'address' => 'required',
            
            
        ];
    }
}
