<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserQuestionResource;
use App\Http\Resources\User\UserResource;
use App\Model\Question;
use App\Model\UserAdditionalQuestion;
use App\Model\UserDetails;
use App\Model\UserQuestion;
use App\Model\UserPrescriptions;
use App\Model\UserLabReports;
use App\Model\UserWalletBalance;
use App\Doctor;
use App\Model\CallLog;
use App\User;
use Auth;
use DB;
use Illuminate\Http\Request;
use Storage;
use Toastr;
use Validator;
use OpenTok\OpenTok;
use OpenTok\MediaMode;
use OpenTok\ArchiveMode;
use OpenTok\Session;
use OpenTok\Role;
use App\Helpers\Helper;

 
class OpentokController extends Controller
{



    public function index($request)
    {
        

        $apiKey = "46393552";
        $apiSecret="0e92fa241b069990f223573515518530011f4507";
        $opentok = new OpenTok($apiKey, $apiSecret);
        $session = $opentok->createSession();
        $sessionId = $session->getSessionId();///for data base store
        $token = $opentok->generateToken($sessionId);
        $token = $session->generateToken();
        $generate_token = $session->generateToken();
        $t=time();
        $data=array('sessionId' => $sessionId, 'generate_token' => $generate_token);

      // $open_tok=DB::table('user_opentok')->where('',)->get();

       $data_video=array(
        'user_id'=>Auth::id(),
        'doctor_id'=>$request->doctor_id,
        'generate_token'=>$generate_token,
        'sessionId'=>$sessionId,
        'time'=>date("h:i:s"),
        'date'=>date("Y-m-d",$t),
        
        );
        DB::table('user_opentok')->insert($data_video);
        Helper::Firebasedata('doctorCall',$data_video);
        
         

        //$data=DB::table('user_opentok')->select('generate_token','sessionId')->get();
        //return response()->json(['status' => true, 'message' => 'User Call', 'data' => $data]);

    }
    public function get_video(Request $request)
    {
        if(Auth::id())
        {
            $video_data=DB::table('user_opentok')->select('id','user_id','generate_token','sessionId')
            ->where('doctor_id',Auth::id())
            ->orderby('id','DESC')
            ->take(1)
            ->get();
        return response()->json(['status' => true, 'message' => 'User Call', 'data' => $video_data]);
        }else{
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
       
    }
    public function assisget_video(Request $request)
    {
        if(Auth::id())
        {
            $DOCTORID=$this->getDoctorid();
            $video_data=DB::table('user_opentok')->select('id','user_id','generate_token','sessionId')
            ->where('doctor_id',$DOCTORID)
            ->orderby('id','DESC')
            ->take(1)
            ->get();
        return response()->json(['status' => true, 'message' => 'User Call', 'data' => $video_data]);
        }else{
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
       
    }
    public function get_video_user(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'doctor_id' => 'required',
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }
       $doctorstatus= Doctor::find($request->doctor_id);
       if($doctorstatus->call_status==1)
       {
        $data[]=array('id'=>'','generate_token'=>'','sessionId'=>'','call_status'=>$doctorstatus->call_status);
        return response()->json(['status' => false, 'message' => 'Doctor is Busy', 'data' => $data]);
       }
        $this->index($request);
        $video_data=DB::table('user_opentok')->select('id','generate_token','sessionId')
                 ->where('user_id',Auth::id())
                 ->where('doctor_id',$request->doctor_id)
                  ->orderby('id','DESC')
                 ->take(1)
                 ->get();

        return response()->json(['status' => true, 'message' => 'User Call', 'data' => $video_data]);
    }
   public function userfirebaseid(Request $request)
   {
       $userid=Auth::id();
       DB::table('users')->updateOrInsert(
        ['id' => $userid],
        ['firebase_id' => $request->firebase_id]
        );
        return response()->json(['status' => true, 'message' => 'firebase id updated or already same']);
   }

   public function doctorfirebaseid(Request $request)
   {
       $userid=Auth::id();
       $rs=DB::table('doctors')
            ->where('id', $userid)
            ->update(['firebase_id' => $request->firebase_id]);
            if($rs)
            {
                return response()->json(['status' => true, 'message' => 'firebase id updated']);
            }else{
                return response()->json(['status' => false, 'message' => 'some thing went wrong']);
            }
   }
   public function Callinitiated(Request $request)
   {
    $validator = Validator::make($request->all(),[
        'useropentokid' => 'required',
        'user_id' => 'required',
        'doctor_id' => 'required',
        'call_at' => 'required',
        'amount' => 'required',
    ]);
    
    if($validator->fails()){
        $errors = collect($validator->messages())->flatten()->toArray();
        return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    }

    try { 
        $obj=new CallLog;
         $obj->useropentokid=$request->useropentokid;
         $obj->user_id=$request->user_id;
         $obj->doctor_id=$request->doctor_id;
         $obj->call_at=$request->call_at;
         $obj->amount=$request->amount;
         $rs=$obj->save();
         if($rs)
         {
            $UserWalletBalance=new  UserWalletBalance;
            $UserWalletBalance->doctor_id=$request->doctor_id;
            $UserWalletBalance->user_id=$request->user_id;
            $UserWalletBalance->payment_type='debit';
            $UserWalletBalance->appointment_type='Accept';
            $UserWalletBalance->amount=($request->amount)?$request->amount:0;
            $UserWalletBalance->transaction_id=time();
            $UserWalletBalance->save();
         }
         $Doctor =Doctor::find($request->doctor_id);
         $Doctor->call_status=1;
         $Doctor->save();
         DB::commit();
        }
        catch (Exception $e) {
            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
        return response()->json(['status' => true, 'message' => 'Call Initiated Success','data'=>$obj]);

   }


   public function Callend(Request $request)
   {
    
    $validator = Validator::make($request->all(),[
        
        'call_end' => 'required',
        
    ]);
    
    if($validator->fails()){
        $errors = collect($validator->messages())->flatten()->toArray();
        return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    }
    try { 
        if($request->id!=0)
        {
            $id=$request->id; 
            $obj=CallLog::find($id);
            $obj->call_end=$request->call_end;
            $obj->save();
        }

         $Doctor =Doctor::find($request->doctor_id);
         $Doctor->call_status=0;
         $Doctor->save();
         DB::commit();
        }
        catch (Exception $e) {
            DB::rollback();
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }
        return response()->json(['status' => true, 'message' => 'Call End Success']);

   }

   public function getDoctorid()
   {
        $rr=DB::table('assistantdoctors')->where('doctor_assistance_id',Auth::id())->first();
          if($rr)
          {
             return $rr->doctor_id;
          }else{
             return Auth::id();
          }
       
   }
}
