<?php

namespace App\Http\Controllers\Api;

use App\Doctor;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Http\Resources\User\UserResource;
use App\Rules\UserExistsRule;
use App\User;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Validator;

class AuthController extends Controller
{
    public function login(Request $request){

    	$validator = Validator::make($request->all(),[
    		'mobile' => 'required|digits:10',
    	]);

    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    	}

        try{
            $user = User::whereMobile($request->mobile)->first();
           // $numbers = range(100000, 20);
         //  $user_elixir_id = shuffle($numbers);
            if(!$user){
                $user = User::create([
                            'mobile' => $request->mobile,
                            'user_elixir_id' =>  mt_rand(100000,999999)
                        ]);
            }

            $otp = $this->send_otp_sms($request->mobile);

            $data = new UserResource($user);
        }
        catch(\Exception $e){
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'User Details', 'otp' => $otp]);
    }

    public function assislogin(Request $request){
           
    	$validator = Validator::make($request->all(),[
    		'mobile' => 'required|digits:10',
    	]);
         
    	if($validator->fails()){
    		$errors = collect($validator->messages())->flatten()->toArray();
    		return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
    	}

        try{
            $user = User::whereMobile($request->mobile)->first();
           // $numbers = range(100000, 20);
         //  $user_elixir_id = shuffle($numbers);
            if(!$user){
                $user = User::create([
                            'mobile' => $request->mobile,
                            'user_elixir_id' =>  mt_rand(100000,999999)
                        ]);
            }

            $otp = $this->assis_send_otp_sms($request->mobile);

            $data = new UserResource($user);
        }
        catch(\Exception $e){
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'User Details', 'otp' => $otp]);
    }

    public function send_otp(Request $request){

        $validator = Validator::make($request->all(),[
            'mobile' => ['required','digits:10', new UserExistsRule()],
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        $otp = $this->send_otp_sms($request->mobile);

        return response()->json(['status' => true, 'message' => 'Otp Sent', 'otp' => $otp]);
    }

    public function assis_send_otp(Request $request){

        $validator = Validator::make($request->all(),[
            'mobile' => ['required','digits:10', new UserExistsRule()],
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        $otp = $this->assis_send_otp_sms($request->mobile);

        return response()->json(['status' => true, 'message' => 'Otp Sent', 'otp' => $otp]);
    }

    

    public function verify_user(Request $request){
        $validator = Validator::make($request->all(),[
            'mobile' => 'required|exists:users,mobile',
            'provider' => [
                'required',
                Rule::in(['users', 'doctors'])
            ]
        ]);

        if($validator->fails()){
            $errors = collect($validator->messages())->flatten()->toArray();
            return response()->json(['status' => false, 'message' => 'Validation Errors', 'data' => $errors]);
        }

        try{

            //print_r($request->mobile); exit;
            if($request->provider === 'users'){
                $user = User::whereMobile($request->mobile)->first();
            }
            else{
                $user = Doctor::whereMobile($request->mobile)
                       ->where('type',$request->type)->first();
            }
            $token = $user->createToken($request->mobile)->accessToken;


        }
        catch(\Exception $e){
            
            return response()->json(['status' => false, 'message' => 'Something Went Wrong']);
        }

        return response()->json(['status' => true, 'message' => 'User Verified', 'token' => $token, 'data' => $user]);
    }

    public function send_otp_sms($mobile){
        //Generate Otp
        
        $otp = rand(1000, 9999);

        // Send Sms with Password
        $data['mobile'] = $mobile;
        $data['msgtxt'] = "<#> Elixir: Your verification code is ".$otp." qcQJU7BA1+i";
         
        Helper::sendSMS($data);

        return $otp;
    }
    public function assis_send_otp_sms($mobile){
        //Generate Otp
        
        $otp = rand(1000, 9999);

        // Send Sms with Password
        $data['mobile'] = $mobile;
        $data['msgtxt'] = "<#> Elixir: Your verification code is ".$otp." xMtWXnQOIUx";
         
        Helper::sendSMS($data);

        return $otp;
    }

    
}
