<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\AppointmentReport;
use App\Model\UserWalletBalance;
use Illuminate\Support\Facades\Storage;
use App\Model\Doctor;
use App\Model\User;
use DB;
class UserWalletController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=UserWalletBalance::with('Doctor','User')->get();
         
        return view('admin.wallet.index', compact('data'));
    }
    
    
    
    public function labreport(Request $request)
    {
        $data = DB::select("SELECT ul.id,ul.user_id,ul.appoinment_type,ul.lab_reports,ul.date,u.mobile FROM `user_lab_reports` ul INNER JOIN users u ON u.id = ul.user_id ORDER BY ul.id DESC;");
         
        return view('admin.wallet.labreport', compact('data'));
    }
    
    
    public function prescription(Request $request)
    {
        $data = DB::select("SELECT ul.id,ul.user_id,ul.appoinment_type,ul.prescription,ul.date,u.mobile FROM `user_prescriptions` ul INNER JOIN users u ON u.id = ul.user_id ORDER BY ul.id DESC;");
         
        return view('admin.wallet.prescription', compact('data'));
    }
   

    public function prescriptionStore(Request $request)
    {
        // ✅ Validate input
        $request->validate([
            'user_id'      => 'required|exists:users,id',
            'doctor_id'    => 'required|exists:doctors,id',
            'reportType'   => 'required|string|in:Prescription,Lab Report',
            'reportUpload' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);
    
        // ✅ Fetch existing record to delete old file if needed
        $existing = DB::table('user_prescriptions')
                      ->where('user_id', $request->input('user_id'))
                      ->latest('id')
                      ->first();
    
        $filePath = $existing ? $existing->prescription : null;
    
        // ✅ Handle file upload and delete old file if exists
        if ($request->hasFile('reportUpload')) {
            if ($filePath && Storage::exists('public/' . $filePath)) {
                Storage::delete('public/' . $filePath);
            }
    
            $filePath = $request->file('reportUpload')->store('labreports', 'public');
        }
    
        $now = now();
    
        // ✅ Insert into `user_prescriptions`
        if ($request->input('reportType') === 'Prescription') {
            DB::table('user_prescriptions')->insert([
                'user_id'         => $request->input('user_id'),
                'appoinment_type' => 'Prescription',
                'prescription'    => $filePath,
                'date'            => $now,
                'created_at'      => $now,
                'updated_at'      => $now,
            ]);
        }
        // 📝 Optionally handle Lab Report case here if needed
    
        // ✅ Fetch all data for view
        $data = DB::select("
            SELECT ul.id, ul.user_id, ul.appoinment_type, ul.prescription, ul.date, u.mobile 
            FROM user_prescriptions ul 
            INNER JOIN users u ON u.id = ul.user_id 
            ORDER BY ul.id DESC
        ");
    
        return view('admin.wallet.prescription', compact('data'));
    }
    
    public function labreportStore(Request $request)
    {
        // ✅ Validate input
        $request->validate([
            'user_id'       => 'required|exists:users,id',
            'doctor_id'     => 'required|exists:doctors,id',
            'reportType'    => 'required|string|in:Prescription,Lab Report',
            'reportUpload'  => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);
    
        // ✅ Handle file upload
        $filePath = null;
        if ($request->hasFile('reportUpload')) {
            $filePath = $request->file('reportUpload')->store('labreports', 'public');
        }
    
        $now = now();
    
        if ($request->input('reportType') === 'Lab Report') {
            // ✅ Insert into `user_lab_reports`
            DB::table('user_lab_reports')->insert([
                'user_id'      => $request->input('user_id'),
                'appoinment_type' => 'Lab Report',
                'lab_reports'  => $filePath,
                'date'         => $now,
                'created_at'   => $now,
                'updated_at'   => $now,
            ]);
        } else {
            
        }
    
        $data = DB::select("SELECT ul.id,ul.user_id,ul.appoinment_type,ul.lab_reports,ul.date,u.mobile FROM `user_lab_reports` ul INNER JOIN users u ON u.id = ul.user_id ORDER BY ul.id DESC;");
             
            return view('admin.wallet.labreport', compact('data'));
    }



    public function labreportUpdate(Request $request, $id)
    {
        // ✅ Validate input
        $request->validate([
            'user_id'       => 'required|exists:users,id',
            'reportType'    => 'required|string|in:Prescription,Lab Report',
            'reportUpload'  => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);
    
        $now = now();
    
        // ✅ Check current report type and fetch the record
        $existing = DB::selectOne("SELECT * FROM user_lab_reports WHERE id = ?", [$id]);
    
        if (!$existing) {
            abort(404);
        }
    
        // ✅ Handle file replacement (if new file uploaded)
        $filePath = $existing->lab_reports;
        if ($request->hasFile('reportUpload')) {
            // Delete old file if exists
            if ($filePath && Storage::exists('public/' . $filePath)) {
                Storage::delete('public/' . $filePath);
            }
    
            // Upload new file
            $filePath = $request->file('reportUpload')->store('labreports', 'public');
        }
    
        // ✅ Update lab report record
        DB::table('user_lab_reports')
            ->where('id', $id)
            ->update([
                'user_id'         => $request->input('user_id'),
                'appoinment_type' => $request->input('reportType'),
                'lab_reports'     => $filePath,
                'updated_at'      => $now,
            ]);
    
        // ✅ Optionally update user name if included (based on your blade)
        if ($request->filled('name')) {
            DB::table('users')
                ->where('id', $existing->user_id)
                ->update(['name' => $request->input('name')]);
        }
    
        $data = DB::select("SELECT ul.id,ul.user_id,ul.appoinment_type,ul.lab_reports,ul.date,u.mobile FROM `user_lab_reports` ul INNER JOIN users u ON u.id = ul.user_id ORDER BY ul.id DESC;");
             
            return view('admin.wallet.labreport', compact('data'));
    }
    
    
    public function prescriptionUpdate(Request $request, $id)
    {
        // ✅ Validate input
        $request->validate([
            'user_id'      => 'required|exists:users,id',
            'reportType'   => 'required|string|in:Prescription,Lab Report',
            'reportUpload' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);
    
        $now = now();
    
        // ✅ Fetch existing record
        $existing = DB::table('user_prescriptions')->where('id', $id)->first();
    
        if (!$existing) {
            abort(404, 'Prescription not found.');
        }
    
        // ✅ Handle file replacement (if new file uploaded)
        $filePath = $existing->prescription; // Correct field name
    
        if ($request->hasFile('reportUpload')) {
            // Delete old file if it exists
            if ($filePath && Storage::exists('public/' . $filePath)) {
                Storage::delete('public/' . $filePath);
            }
    
            // Upload new file
            $filePath = $request->file('reportUpload')->store('labreports', 'public');
        }
    
        // ✅ Update the prescription record
        DB::table('user_prescriptions')->where('id', $id)->update([
            'user_id'         => $request->input('user_id'),
            'appoinment_type' => $request->input('reportType'),
            'prescription'    => $filePath,
            'updated_at'      => $now,
        ]);
    
        // ✅ Optionally update user name
        if ($request->filled('name')) {
            DB::table('users')
                ->where('id', $existing->user_id)
                ->update(['name' => $request->input('name')]);
        }
    
        // ✅ Fetch updated data
        $data = DB::select("
            SELECT ul.id, ul.user_id, ul.appoinment_type, ul.prescription, ul.date, u.mobile 
            FROM user_prescriptions ul 
            INNER JOIN users u ON u.id = ul.user_id 
            ORDER BY ul.id DESC
        ");
    
        return view('admin.wallet.prescription', compact('data'));
    }
    
    public function prescriptionDelete($id)
    {
        DB::delete("DELETE FROM user_prescriptions WHERE id = ?", [$id]);
    
         // ✅ Fetch updated data
        $data = DB::select("
            SELECT ul.id, ul.user_id, ul.appoinment_type, ul.prescription, ul.date, u.mobile 
            FROM user_prescriptions ul 
            INNER JOIN users u ON u.id = ul.user_id 
            ORDER BY ul.id DESC
        ");
    
        return view('admin.wallet.prescription', compact('data'));
    }
    
    
    
    public function labreportDelete($id)
    {
        DB::delete("DELETE FROM user_lab_reports WHERE id = ?", [$id]);
    
         $data = DB::select("SELECT ul.id,ul.user_id,ul.appoinment_type,ul.lab_reports,ul.date,u.mobile FROM `user_lab_reports` ul INNER JOIN users u ON u.id = ul.user_id ORDER BY ul.id DESC;");
             
            return view('admin.wallet.labreport', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
        return view('admin.wallet.create',compact('doctor','user'));
    }
    
    public function labReportCreate()
    {
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
        return view('admin.wallet.labReportCreate',compact('doctor','user')); 
    }
    
    
     public function prescriptionCreate()
    {
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
        return view('admin.wallet.prescriptionCreate',compact('doctor','user')); 
    }
    
    public function labreportEdit($id)
    {
        $report = DB::selectOne("SELECT 
        ul.id, 
        ul.user_id, 
    
        ul.appoinment_type AS reportType, 
        ul.lab_reports AS reportUpload, 
        ul.date, 
        u.name, 
        u.mobile AS phoneNumber 
        FROM user_lab_reports ul 
        INNER JOIN users u ON u.id = ul.user_id 
        WHERE ul.id = ?", [$id]);
    
        if (!$report) {
            abort(404);
        }
    
        // Convert stdClass to array for Form::model compatibility
        $report = (array) $report;
        
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
    
        return view('admin.wallet.labReportEdit', compact('report', 'doctor','user'));
    }
    
     public function prescriptionEdit($id)
    {
        $report = DB::selectOne("SELECT 
        ul.id, 
        ul.user_id, 
    
        ul.appoinment_type AS reportType, 
        ul.prescription AS reportUpload, 
        ul.date, 
        u.name, 
        u.mobile AS phoneNumber 
        FROM user_prescriptions ul 
        INNER JOIN users u ON u.id = ul.user_id 
        WHERE ul.id = ?", [$id]);
    
        if (!$report) {
            abort(404);
        }
    
        // Convert stdClass to array for Form::model compatibility
        $report = (array) $report;
        
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
    
        return view('admin.wallet.prescriptionEdit', compact('report', 'doctor','user'));
    }

    public function prescriptionShow($id){
        $report = DB::selectOne("SELECT 
        ul.id, 
        ul.user_id, 
    
        ul.appoinment_type AS reportType, 
        ul.prescription AS reportUpload, 
        ul.date, 
        u.name, 
        u.mobile AS phoneNumber 
        FROM user_prescriptions ul 
        INNER JOIN users u ON u.id = ul.user_id 
        WHERE ul.id = ?", [$id]);
    
        if (!$report) {
            abort(404);
        }
    
        // Convert stdClass to array for Form::model compatibility
        $report = (array) $report;
        
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
    
        return view('admin.wallet.prescriptionShow', compact('report', 'doctor','user'));
    }

    public function labreportShow($id)
    {
        $report = DB::selectOne("SELECT 
        ul.id, 
        ul.user_id, 
    
        ul.appoinment_type AS reportType, 
        ul.lab_reports AS reportUpload, 
        ul.date, 
        u.name, 
        u.mobile AS phoneNumber 
        FROM user_lab_reports ul 
        INNER JOIN users u ON u.id = ul.user_id 
        WHERE ul.id = ?", [$id]);
        if (!$report) {
            abort(404);
        }
    
        $report = (array) $report;
        
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
    
        return view('admin.wallet.labReportView', compact('report', 'doctor','user'));
    }

   

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $obj=new  UserWalletBalance;
       $obj->doctor_id=$request->doctor_id;
       $obj->user_id=$request->user_id;
       $obj->payment_type=$request->payment_type;
       $obj->appointment_type=$request->appointment_type;
       $obj->amount=($request->amount)?$request->amount:0;
       $obj->transaction_id=time();
       $obj->save();
       
       
       
        
        $data = [
            'user_id'        => $request->user_id,
            'doctor_id'      => $request->doctor_id,
            'transaction_id' => $request->payment_type,
            'total_amount'   => ($request->amount)?$request->amount:0,
            'created_at'     => now(),
            'updated_at'     => now(),
        ];
        $inserted=  DB::table('user_amount')->insert($data);
        
        
       return redirect()->route('wallet.index')->with('message','Money Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
         $data=UserWalletBalance::with('Doctor','User')->get();
         
        return view('admin.wallet.labreport', compact('data'));
    }
    
   

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=UserWalletBalance::with('Doctor','User')->where('id',$id)->first();
        $doctor=Doctor::pluck('name', 'id');
        $user=User::pluck('mobile', 'id');
        return view('admin.wallet.edit',compact('doctor','user','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $obj=UserWalletBalance::find($id);
        $obj->doctor_id=$request->doctor_id;
        $obj->user_id=$request->user_id;
        $obj->payment_type=$request->payment_type;
        $obj->appointment_type=$request->appointment_type;
        $obj->amount=($request->amount)?$request->amount:0;
        $obj->transaction_id=time();
        $obj->save();
        
        return redirect()->route('wallet.index')->with('message','Money Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $obj = UserWalletBalance::findOrFail($id);
         
        $obj->delete();
       
        return redirect()->route('wallet.index')->with('message','Data Deleted ');
    }

    public function massDestroy(Request $request)
    {
        
        if ($request->input('ids')) {
            $entries = UserWalletBalance::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
}
