<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\User;
use App\Model\UserDetail;
use App\Model\DiagnosisNote;
use App\Http\Requests\UserRequest;
use App\Http\Requests\UserupdateRequest;
use App\Model\UserPrescriptions;
use File;
use Image;
use Storage;
use DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Exceptions\Handler;
use Exception;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $data = User::with(['userDetail', 'walletBalance'])->get();

        return view('admin.user.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.user.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(UserRequest $request)
    {
        $image = $request->file('profile');
        if($image)
        {
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('profile/images');
            if(!File::exists($destinationPath)) {
                File::makeDirectory($destinationPath, $mode = 0777, true);
             } 
            
            // $image->move($destinationPath, $input['imagename']);
            // $mainimge='profile/images/'.$input['imagename'];
            $path = Storage::put('uploads/profile', $request->file('profile'));
            
        }else{
            $path='';
             
        }
         
        $obj= new User;
        $obj->user_elixir_id=$request->user_elixir_id;
        $obj->name=$request->name;
        $obj->mobile=$request->mobile ;
        $obj->email=$request->email;
        $obj->online_status=$request->online_status;
        $obj->save();
        $userid=$obj->id;

        $obj2=new UserDetail;
        $obj2->user_id=$userid;
        $obj2->dob=$request->dob;
        $obj2->gender=$request->gender;
        $obj2->profile=$path;
        $obj2->save();

        return redirect()->route('user.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=User::with('userDetail')->where('id',$id)->first();
         return view('admin.user.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UserupdateRequest $request, $id)
    {
        $image = $request->file('profile');
        $path='';
        if($image)
        {
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('profile/images');
            if(!File::exists($destinationPath)) {
                File::makeDirectory($destinationPath, $mode = 0777, true);
             } 
             
             $path = Storage::put('uploads/profile', $request->file('profile'));
             

            //$image->move($destinationPath, $input['imagename']);
            //$mainimge='profile/images/'.$input['imagename'];
            
        } 
         
        $obj= User::findOrFail($id);
        $obj->user_elixir_id=$request->user_elixir_id;
        $obj->name=$request->name;
        $obj->mobile=$request->mobile ;
        $obj->email=$request->email;
        $obj->online_status=$request->online_status;
        $obj->save();
        $userid=$obj->id;
            
        $rs=UserDetail::where('user_id',$userid)->first();

        if($rs)
        {
        	 $obj2= UserDetail::findOrFail($rs->id);
        	}else{

        	  $obj2= new  UserDetail;
        }
       
        $obj2->user_id=$userid;
        $obj2->dob=$request->dob;
        $obj2->gender=$request->gender ;
        $obj2->profile=($path)?$path:$obj2->profile;
        $obj2->save();
        return redirect()->route('user.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $obj = User::findOrFail($id);
         
        $obj->delete();
       
        return redirect()->route('user.index');
    }

    public function uploaduser(Request $request)
    {
        return view('admin.user.uploadform');
    }

    public function import(Request $request)
    {
        $request->validate([
            'uploadfile' => 'required'
        ]);
        
        ini_set('max_execution_time', 1000); //3 minutes
        
            $path = $request->file('uploadfile')->getRealPath();
            $data = \Excel::load($path)->get();
            //dd($data);
              //DB::beginTransaction();
            if($data->count()){
                try {
                foreach ($data as $key => $value) {
                     $check=User::where('user_elixir_id',$value->id)->orwhere('mobile',$value->mobile)->get();
                     if(count($check)>0) continue;
                     
                    if($value->id!='' && $value->name_of_the_patient!='' && $value->mobile!='')
                   
                    {
                        
                     $User=New User;
                     $User->user_elixir_id=$value->id;
                     $User->mobile =$value->mobile;
                     $User->name=$value->name_of_the_patient;
                     $User->online_status=2;
                     $User->email=$value->email;
                     $User->save();
                     $userid=$User->id;
                     $UserDetail=new UserDetail;
                     $UserDetail->user_id=$userid;
                     if($value->d_o_b!='')
                     {
                        $UserDetail->dob =date('Y-m-d', strtotime($value->d_o_b)); 
                     }
                     $UserDetail->gender =($value->gen)?? 3;
                     $UserDetail->save();

                     $diagnosis=$value->diagnosis;
                     $DiagnosisNote=new DiagnosisNote;
                     $DiagnosisNote->user_id=$User->id;
                     $DiagnosisNote->doctor_id=1;
                     $DiagnosisNote->notes=$diagnosis;
                     $DiagnosisNote->save();
                     
                     $UserPrescriptions=new UserPrescriptions;
                     $UserPrescriptions->appoinment_type=1;
                     $UserPrescriptions->user_id=$User->id;
                     $UserPrescriptions->prescription_text=$value->last_presription;
                     $UserPrescriptions->save();
                    }
                    
                }
                //DB::commit();
                return back()->with('success','Insert Record successfully.');
            } catch (\Exception $e) {
                         
                 //dd($e);
                 //DB::rollback();
                return back()->with('error','Something Wrong');
            }
               
               
            }else{
                return back()->with('error','please check XLSX seet data');
            }
            
         
        
        
    }

    public function massDestroy(Request $request)
    {
        
        if ($request->input('ids')) {
            $entries = User::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
}
