<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Doctor;
use App\Model\DoctorDetail;
use File;
use Image;
use App\Http\Requests\DoctorRequest;
use App\Http\Requests\DoctorupdateRequest;
use Kreait\Firebase;
use Kreait\Firebase\Factory;
use Kreait\Firebase\ServiceAccount;
class DoctorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       //dd(__DIR__.'/elixer-e2dee-firebase-adminsdk-6h6n3-b61e63525b.json');
        // $serviceAccount = ServiceAccount::fromJsonFile(__DIR__.'/elixer-e2dee-firebase-adminsdk-6h6n3-b61e63525b.json');
        // $firebase = (new Factory)
        // ->withServiceAccount($serviceAccount)
        // ->withDatabaseUri('https://elixer-e2dee.firebaseio.com/')
        // ->create();

        // $database = $firebase->getDatabase();

        // $newPost = $database
        // ->getReference('blog/posts')
        // ->push([
        // 'title' => 'Laravel FireBase Tutorial' ,
        // 'category' => 'Laravel'
        // ]);
         

        $data=Doctor::with('doctordetail')->get();
        return view('admin.doctor.index', compact('data'));
    }

    public function Peripheraldoctor()
    {
        $data=Doctor::with('doctordetail')->where('type',2)->get();
        return view('admin.doctor.peripheral', compact('data'));
    }

    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    { 
        return view('admin.doctor.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DoctorRequest $request)
    {
        $image = $request->file('profile');
        if($image)
        {
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('profile/images');
            if(!File::exists($destinationPath)) {
                File::makeDirectory($destinationPath, $mode = 0777, true);
             } 
            $image->move($destinationPath, $input['imagename']);
            $mainimge='profile/images/'.$input['imagename'];
            
        }else{
            $mainimge='';
             
        }
         
        $obj= new Doctor;
        $obj->doctor_elixir_id=$request->doctor_elixir_id;
        $obj->name=$request->name;
        $obj->mobile=$request->mobile ;
        $obj->type=$request->type;
        $obj->email=$request->email;
        $obj->online_status=$request->online_status;
        $obj->save();
        $doctorid=$obj->id;
        $obj2=new DoctorDetail;
        
        $obj2->doctor_id=$doctorid;
        $obj2->DOB=$request->dob;
        $obj2->gender=$request->gender ;
        $obj2->specialization=$request->specialization;
        $obj2->organisation=$request->organisation;
        $obj2->about=$request->about;
        $obj2->education=$request->education;
        $obj2->adwards_and_certificates=$request->adwards_and_certificates;
        $obj2->registration=$request->registration;
        $obj2->address=$request->address;
        $obj2->profile=$mainimge;
        $obj2->save();

        return redirect()->route('doctor.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         
         $data=Doctor::with('doctordetail')->where('id',$id)->first();
         return view('admin.doctor.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(DoctorupdateRequest $request, $id)
    {
         
        $image = $request->file('profile');
        if($image)
        {
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('profile/images');
            if(!File::exists($destinationPath)) {
                File::makeDirectory($destinationPath, $mode = 0777, true);
             } 
            $image->move($destinationPath, $input['imagename']);
            $mainimge='profile/images/'.$input['imagename'];
            
        }else{
            $mainimge='';
             
        }
         
        $obj= Doctor::findOrFail($id);
        
        $obj->doctor_elixir_id=$request->doctor_elixir_id;
        $obj->name=$request->name;
        $obj->mobile=$request->mobile ;
        $obj->type=$request->type;
        $obj->email=$request->email;
        $obj->online_status=$request->online_status;
        $obj->call_status=$request->call_status;
        
        $obj->save();
        $doctorid=$obj->id;
        $rs=DoctorDetail::where('doctor_id',$doctorid)->first();
       
        $obj2= DoctorDetail::findOrFail($rs->id);
        $obj2->doctor_id=$doctorid;
        $obj2->DOB=$request->dob;
        $obj2->gender=$request->gender ;
        $obj2->specialization=$request->specialization;
        $obj2->organisation=$request->organisation;
        $obj2->about=$request->about;
        $obj2->education=$request->education;
        $obj2->adwards_and_certificates=$request->adwards_and_certificates;
        $obj2->registration=$request->registration;
        $obj2->address=$request->address;
        $obj2->profile=$mainimge;
        $obj2->update();
        return redirect()->route('doctor.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $obj = Doctor::findOrFail($id);
         
        $obj->delete();
       
        return redirect()->route('doctor.index');
    }

    public function massDestroy(Request $request)
    {
        
        if ($request->input('ids')) {
            $entries = Doctor::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
}
