<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Doctor;
use App\Model\DoctorDetail;
use App\Model\Assistantdoctor;
use Kreait\Firebase\Factory;
use Kreait\Firebase\ServiceAccount;
use DB;
class AssistantdoctorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=DB::table('assistantdoctors')
            ->join('doctors','doctors.id','assistantdoctors.doctor_id')
            ->select('assistantdoctors.*','doctors.name')
            ->get();
            
         $assistancedoc=DB::table('doctors')->where('type',2)->pluck('name','id');
          
        return view('admin.assis-doctor.index', compact('data','assistancedoc'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $doctor=DB::table('doctors')->where('type',1)->pluck('name','id');
        $assistancedoc=DB::table('doctors')->where('type',2)->pluck('name','id');
        return view('admin.assis-doctor.create',compact('doctor','assistancedoc'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $rs=Assistantdoctor::where('doctor_id',$request->doctor_id)->get();
         if(count($rs)==0)
         {
            $obj= new Assistantdoctor;
            $obj->doctor_id=$request->doctor_id;
            $obj->doctor_assistance_id=$request->doctor_assistance_id;
            $obj->save();
         } else{
            return redirect()->route('assisdoctor.index')->with('error','Already Assistant doctor');
         }              
        
        return redirect()->route('assisdoctor.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       
        $data= Assistantdoctor::find($id);
         
        $doctor=DB::table('doctors')->where('type',1)->pluck('name','id');
        $assistancedoc=DB::table('doctors')->where('type',2)->pluck('name','id');
        return view('admin.assis-doctor.edit',compact('doctor','assistancedoc','data'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $obj= Assistantdoctor::find($request->id);
        $obj->doctor_id=$request->doctor_id;
        $obj->doctor_assistance_id=$request->doctor_assistance_id;
        $obj->save();
          
        return redirect()->route('assisdoctor.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $obj = Assistantdoctor::findOrFail($id);
         
        $obj->delete();
       
        return redirect()->route('assisdoctor.index');
    }

    public function massDestroy(Request $request)
    {
        
        if ($request->input('ids')) {
            $entries = Assistantdoctor::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
}
