<?php

namespace App;

use App\Model\DoctorDetails;
use App\Model\DoctorRates;
use App\Model\Slot;
use App\Notifications\DoctorResetPassword;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use SMartins\PassportMultiauth\HasMultiAuthApiTokens;

class Doctor extends Authenticatable
{
    use Notifiable, HasMultiAuthApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * Send the password reset notification.
     *
     * @param  string  $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new DoctorResetPassword($token));
    }

    public function findForPassport($username)
    {
        return $this->where('mobile', $username)->first();
    }

    public function doctor_details(){
        return $this->hasOne(DoctorDetails::class);
    }

    public function doctor_rates(){
        return $this->hasOne(DoctorRates::class);
    }

    public function slots(){
        return $this->hasMany(Slot::class);
    }

    public function scopeFindByMobile($query, $mobile){
        return $query->where('mobile', $mobile);
    }
}
